% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary1d.R
\name{matern.rational}
\alias{matern.rational}
\title{Rational approximation of the Matern fields on intervals and metric graphs}
\usage{
matern.rational(
  graph = NULL,
  loc = NULL,
  bc = c("free", "Neumann", "Dirichlet"),
  kappa = NULL,
  range = NULL,
  nu = NULL,
  sigma = NULL,
  tau = NULL,
  alpha = NULL,
  m = 2,
  parameterization = c("matern", "spde"),
  type_rational_approximation = "brasil",
  type_interp = "spline"
)
}
\arguments{
\item{graph}{Metric graph object. The default is NULL, which means that a stationary
Matern model on the line is created.}

\item{loc}{Locations where to evaluate the model.}

\item{bc}{Specifies the boundary conditions. The default is "free" which gives
stationary Matern models on intervals. Other options are "Neumann" or "Dirichlet".}

\item{kappa}{Range parameter}

\item{range}{practical correlation range}

\item{nu}{Smoothness parameter}

\item{sigma}{Standard deviation}

\item{tau}{Precision parameter}

\item{alpha}{Smoothness parameter}

\item{m}{The order of the approximation}

\item{parameterization}{Which parameterization to use? \code{matern} uses range, std. deviation and nu
(smoothness). \code{spde} uses kappa, tau and alpha. The default is \code{matern}.}

\item{type_rational_approximation}{Method used to compute the coefficients of the rational approximation.}

\item{type_interp}{Interpolation method for the rational coefficients.}
}
\value{
A model object for the the approximation
}
\description{
The function is used for computing an approximation,
which can be used for inference and simulation, of the fractional SPDE
\deqn{(\kappa^2 - \Delta)^{\alpha/2} (\tau u(s)) = W}
on intervals or metric graphs. Here \eqn{W} is Gaussian white noise,
\eqn{\kappa} controls the range, \eqn{\alpha = \nu + 1/2} with \eqn{\nu>0}
controls the smoothness and \eqn{\tau} is related to the marginal variances
through
\deqn{\sigma^2 = \frac{\Gamma(\nu)}{\tau^2\Gamma(\alpha)2\sqrt{\pi}\kappa^{2\nu}}.}
}
\examples{
s <- seq(from = 0, to = 1, length.out = 101)
kappa <- 20
sigma <- 2
nu <- 0.8
r <- sqrt(8*nu)/kappa #range parameter
op_cov <- matern.rational(loc = s, nu = nu, range = r, sigma = sigma, m = 2, 
parameterization = "matern")
cov.true <- matern.covariance(abs(s-s[1]), kappa = kappa, sigma = sigma, nu = nu)
cov.approx <- op_cov$covariance(ind = 1)

plot(s, cov.true)
lines(s, cov.approx, col = 2)
}
