/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNKeywords;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class AbstractClientAdapter
implements ISVNClientAdapter {
    public void setKeywords(File file, SVNKeywords sVNKeywords, boolean bl) throws SVNClientException {
        this.propertySet(file, "svn:keywords", sVNKeywords.toString(), bl);
    }

    public SVNKeywords addKeywords(File file, SVNKeywords sVNKeywords) throws SVNClientException {
        SVNKeywords sVNKeywords2 = this.getKeywords(file);
        if (sVNKeywords.isHeadUrl()) {
            sVNKeywords2.setHeadUrl(true);
        }
        if (sVNKeywords.isId()) {
            sVNKeywords2.setId(true);
        }
        if (sVNKeywords.isLastChangedBy()) {
            sVNKeywords2.setLastChangedBy(true);
        }
        if (sVNKeywords.isLastChangedDate()) {
            sVNKeywords2.setLastChangedBy(true);
        }
        if (sVNKeywords.isLastChangedRevision()) {
            sVNKeywords2.setLastChangedRevision(true);
        }
        this.setKeywords(file, sVNKeywords2, false);
        return sVNKeywords2;
    }

    public SVNKeywords removeKeywords(File file, SVNKeywords sVNKeywords) throws SVNClientException {
        SVNKeywords sVNKeywords2 = this.getKeywords(file);
        if (sVNKeywords.isHeadUrl()) {
            sVNKeywords2.setHeadUrl(false);
        }
        if (sVNKeywords.isId()) {
            sVNKeywords2.setId(false);
        }
        if (sVNKeywords.isLastChangedBy()) {
            sVNKeywords2.setLastChangedBy(false);
        }
        if (sVNKeywords.isLastChangedDate()) {
            sVNKeywords2.setLastChangedBy(false);
        }
        if (sVNKeywords.isLastChangedRevision()) {
            sVNKeywords2.setLastChangedRevision(false);
        }
        this.setKeywords(file, sVNKeywords2, false);
        return sVNKeywords2;
    }

    public List getIgnoredPatterns(File file) throws SVNClientException {
        if (!file.isDirectory()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ISVNProperty iSVNProperty = this.propertyGet(file, "svn:ignore");
        if (iSVNProperty == null) {
            return arrayList;
        }
        String string = iSVNProperty.getValue();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null || string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        return this.getLogMessages(file, sVNRevision, sVNRevision2, true);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        return this.getLogMessages(sVNUrl, sVNRevision, sVNRevision2, true);
    }

    public void setIgnoredPatterns(File file, List list) throws SVNClientException {
        if (!file.isDirectory()) {
            return;
        }
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuffer.append(string2 + string);
        }
        this.propertySet(file, "svn:ignore", stringBuffer.toString(), false);
    }

    public void addToIgnoredPatterns(File file, String string) throws SVNClientException {
        List list = this.getIgnoredPatterns(file);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals(string)) continue;
            return;
        }
        list.add(string);
        this.setIgnoredPatterns(file, list);
    }

    public SVNKeywords getKeywords(File file) throws SVNClientException {
        ISVNProperty iSVNProperty = this.propertyGet(file, "svn:keywords");
        if (iSVNProperty == null) {
            return new SVNKeywords();
        }
        String string = iSVNProperty.getValue();
        return new SVNKeywords(string);
    }

    public void addPasswordCallback(ISVNPromptUserPassword iSVNPromptUserPassword) {
    }

    public boolean statusReturnsRemoteInfo() {
        return false;
    }

    public long[] commitAcrossWC(File[] fileArray, String string, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    protected void notImplementedYet() throws SVNClientException {
        throw new SVNClientException("Not implemented yet");
    }

    public boolean canCommitAcrossWC() {
        return false;
    }

    public void mkdir(SVNUrl sVNUrl, boolean bl, String string) throws SVNClientException {
        SVNUrl sVNUrl2;
        if (bl && (sVNUrl2 = sVNUrl.getParent()) != null) {
            ISVNInfo iSVNInfo = null;
            try {
                iSVNInfo = this.getInfo(sVNUrl2);
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            if (iSVNInfo == null) {
                this.mkdir(sVNUrl2, bl, string);
            }
        }
        this.mkdir(sVNUrl, string);
    }

    public static boolean isOsWindows() {
        try {
            return System.getProperty("os.name").startsWith("Windows");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

