/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.python.expose.generate.DescriptorExposer;
import org.python.expose.generate.ExposedTypeProcessor;
import org.python.expose.generate.Exposer;
import org.python.expose.generate.InvalidExposingException;
import org.python.expose.generate.MethodExposer;
import org.python.objectweb.asm.ClassWriter;
import org.python.util.Generic;

public class ExposeTask
extends MatchingTask {
    private Path src;
    private File destDir;
    private Set<File> toExpose = Generic.set();

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.toExpose.clear();
        for (String srcEntry : this.src.list()) {
            File file = this.getProject().resolveFile(srcEntry);
            if (!file.exists()) {
                throw new BuildException("srcdir '" + file.getPath() + "' does not exist!", this.getLocation());
            }
            String[] files = this.getDirectoryScanner(file).getIncludedFiles();
            this.scanDir(file, this.destDir != null ? this.destDir : file, files);
        }
        if (this.toExpose.size() > 1) {
            this.log("Exposing " + this.toExpose.size() + " classes");
        } else if (this.toExpose.size() == 1) {
            this.log("Exposing 1 class");
        }
        for (File f : this.toExpose) {
            ExposedTypeProcessor etp;
            try {
                etp = new ExposedTypeProcessor(new FileInputStream(f));
            }
            catch (IOException e) {
                throw new BuildException("Unable to read '" + f + "' to expose it", (Throwable)e);
            }
            catch (InvalidExposingException iee) {
                throw new BuildException(iee.getMessage());
            }
            for (MethodExposer methodExposer : etp.getMethodExposers()) {
                this.generate(methodExposer);
            }
            for (DescriptorExposer descriptorExposer : etp.getDescriptorExposers()) {
                this.generate(descriptorExposer);
            }
            if (etp.getNewExposer() != null) {
                this.generate(etp.getNewExposer());
            }
            this.generate(etp.getTypeExposer());
            this.write(etp.getExposedClassName(), etp.getBytecode());
        }
    }

    private void generate(Exposer exposer) {
        ClassWriter writer = new ClassWriter(2);
        exposer.generate(writer);
        this.write(exposer.getClassName(), writer.toByteArray());
    }

    private void write(String destClass, byte[] newClassfile) {
        File dest = new File(this.destDir, destClass.replace('.', '/') + ".class");
        dest.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest);
            out.write(newClassfile);
        }
        catch (IOException e) {
            throw new BuildException("Unable to write to '" + dest + "'", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m = new GlobPatternMapper();
        m.setFrom("*.class");
        m.setTo("*.class");
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        for (File file : sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m)) {
            this.toExpose.add(file);
        }
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null || this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory '" + this.destDir + "' does not exist " + "or is not a directory", this.getLocation());
        }
    }
}

