% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.R
\name{knn}
\alias{knn}
\title{K Nearest Neighbors}
\usage{
knn(
  query,
  ref,
  k,
  distance = "euclidean",
  same = FALSE,
  threads = 1L,
  verbose = FALSE,
  progress = FALSE,
  ...
)
}
\arguments{
\item{query}{A \code{data.table} containing the set of query points where each row represent a point and each column a given coordinate.}

\item{ref}{A \code{numeric} containing the set of reference points where each row represent a point and each column a given coordinate.}

\item{k}{An \code{integer} describing the number of nearest neighbors to search for.}

\item{distance}{Type of distance to calculate. \code{"euclidean"} as default. Look \code{hnsw_knn} for more options.}

\item{same}{Logic. If \code{TRUE}, it delete neighbors with distance of 0, useful when the k search is based on the same query.}

\item{threads}{An \code{integer} specifying the number of threads to use for parallel processing. Experiment to see what works best for your data on your hardware.}

\item{verbose}{If TRUE, log messages to the console.}

\item{progress}{If TRUE, log a progress bar when \code{verbose = TRUE}. Tracking progress could cause a small overhead.}

\item{...}{Arguments passed to \code{hnsw_build} and \code{hnsw_search}.}
}
\value{
A \code{data.table} with three columns describing the indices of the query, ref, and k neighbors and the distances.
}
\description{
Adapted K nearest neighbors based on \code{RcppHNSW}
}
\details{
This function is based on hnswlib C++ library (Malkov & Yashunin 2016) and
its bindings for R (RcppHNSW; Melville 2020) for a fast estimation of neighbors
points. It is adapted to simplify the workflow within rTLS.
If you use this function, please consider cite the C++ library and
\code{RcppHNSW} package.
}
\examples{

#Point cloud
data("pc_tree")

#knn search using k = 3
knn(pc_tree, pc_tree, k = 3, same = TRUE)

}
\references{
Malkov, Y. A., & Yashunin, D. A. (2016). Efficient and robust approximate nearest neighbor search using Hierarchical Navigable Small World graphs. arXiv preprint arXiv:1603.09320.
}
\seealso{
\code{\link{radius_search}}
}
\author{
J. Antonio Guzmán Q.
}
