% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rTensor_Decomp.R
\name{t_svd}
\alias{t_svd}
\title{Tensor Singular Value Decomposition}
\usage{
t_svd(tnsr)
}
\arguments{
\item{tnsr}{3-Tensor to decompose via TSVD}
}
\value{
a list containing the following:\describe{
\item{\code{U}}{the left orthgonal 3-Tensor}
\item{\code{V}}{the right orthgonal 3-Tensor}
\item{\code{S}}{the middle 3-Tensor consisting of face-wise diagonal matrices}
}
}
\description{
TSVD for a 3-Tensor. Constructs 3-Tensors \code{U, S, V} such that \code{tnsr = t_mult(t_mult(U,S),t(V))}. \code{U} and \code{V} are orthgonal 3-Tensors with orthogonality defined in Kilmer et al. (2013), and \code{S} is a 3-Tensor consists of facewise diagonal matrices. For more details on the TSVD, consult Kilmer et al. (2013).
}
\note{
Computation involves complex values, but if the inputs are real, then the outputs are also real. Some loss of precision occurs in the truncation of the imaginary components during the FFT and inverse FFT.
}
\examples{
tnsr <- rand_tensor()
tsvdD <- t_svd(tnsr)
}
\references{
M. Kilmer, K. Braman, N. Hao, and R. Hoover, "Third-order tensors as operators on matrices: a theoretical and computational framework with applications in imaging". SIAM Journal on Matrix Analysis and Applications 2013.
}
\seealso{
\code{\link{t_mult}}, \code{\link{t_svd_reconstruct}}
}
