% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_project.R
\name{make_project}
\alias{make_project}
\title{Make an Analysis Project}
\usage{
make_project(
  path,
  type = c("Quarto (analysis.qmd)", "R Markdown (analysis.Rmd)"),
  example = FALSE,
  vignette = FALSE,
  overwrite = FALSE,
  openInteractive = TRUE
)
}
\arguments{
\item{path}{Path automatically set by research_project.dcf (see
\code{./rstudio/templates/project/})}

\item{type}{Choose between "Quarto (analysis.qmd)" or
"R Markdown (analysis.Rmd)"}

\item{example}{Will the analysis file include an example table/figure?}

\item{vignette}{Will the analysis file be saved as a package vignette?}

\item{overwrite}{Will an existing RStudio project be overwritten?  This is 
needed for for Posit.Cloud.  You will be prompted to confirm this option.}

\item{openInteractive}{Should this new project be opened in a new RStudio
window? Defaults to \code{TRUE}. NOTE: this option exists to prevent 
RStudio from opening two duplicate versions of the new project when
this function is executed from RStudio menus. MODIFY WITH CAUTION.}
}
\value{
Returns nothing.  See description above.
}
\description{
This function makes an R project that includes an analysis.Rmd
or analysis.qmd file using the conflicted and tidyverse packages.  This
project automatically includes an aggressive .gitignore which is designed to
help protect against leaking data (with protected  health information), a
starter bibliography file called "references" (in standard .bib format),
and a stock Citation Style Language (.csl) file for the New England Journal
of Medicine.
}
\details{
Behind the scenes, this function used by research_project.dcf when
a user selects New project... > New Directory > rUM Research Project Template
within the RSutdio IDE. See \code{./rstudio/templates/project/}.
}
\examples{
\dontrun{
  # This makes a project with an example Quarto paper in the project's folder.
  make_project(path = "~/test", type = "Quarto (analysis.qmd)", example = TRUE, vignette = TRUE)
  # make_project() allows abbreviations on the project type: "Q" for Quarto or "R" for R Markdown
  make_project(path = "~/test_project", "Q", TRUE, TRUE)
  
  # This makes a project with an example R Markdown paper in the project's folder.
  make_project(path = "~/test", type = "R Markdown (analysis.Rmd)", example = TRUE, vignette = TRUE)
  # This makes a project with an example paper in the project's folder.
  make_project(path = "~/test_project", "R", example = TRUE)
}
}
