% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{deletionsByVpooled}
\alias{deletionsByVpooled}
\title{Single chromosomal D or J gene deletions inferred by the V pooled method}
\usage{
deletionsByVpooled(clip_db, deletion_col = c("D_CALL"),
  count_thresh = 50, deleted_genes = "", min_minor_fraction = 0.3,
  kThreshDel = 3, nonReliable_Vgenes = c())
}
\arguments{
\item{clip_db}{a \code{data.frame} in Change-O format. See details.}

\item{deletion_col}{a vector of column names for which single chromosome deletions should be inferred. Default is J_CALL and D_CALL.}

\item{count_thresh}{integer, the minimun number of sequences mapped to a specific V gene to be included in the V pooled inference.}

\item{deleted_genes}{double chromosome deletion summary table. A \code{data.frame} created by \code{deletionsByBinom}.}

\item{min_minor_fraction}{the minimum minor allele fraction to be used as an anchor gene. Default is 0.3}

\item{kThreshDel}{the minimum lK (log10 of the Bayes factor) to call a deletion. Defualt is 3.}

\item{nonReliable_Vgenes}{a list of known non reliable gene assignments. A \code{list} created by \code{nonReliableVGenes}.}
}
\value{
A \code{data.frame}, in which each row is the single chomosome deletion inference of a gene.

The output containes the following columns:
\itemize{
 \item \code{SUBJECT}:       the subject name.
 \item \code{GENE}:          the gene call
 \item \code{DELETION}:      chromosome deletions inferred. Encoded 1 for deletion and 0 for no deletion.
 \item \code{K}:             the Bayesian factor value for the deletion inference.
 \item \code{COUNTS}:        the appereance count of the gene on each chromosome, the counts are seperated by a comma.
}
}
\description{
The \code{deletionsByVpooled} function inferes single chromosomal deletion for D and J gene .
}
\details{
The function accepts a \code{data.frame} in Change-O format (\url{https://changeo.readthedocs.io/en/version-0.4.1---airr-standards/standard.html}) containing the following columns:
\itemize{
  \item \code{'SUBJECT'}: The subject name
  \item \code{'V_CALL'}: V allele call(s) (in an IMGT format)
  \item \code{'D_CALL'}: D allele call(s) (in an IMGT format, only for heavy chains)
  \item \code{'J_CALL'}: J allele call(s) (in an IMGT format)
}
}
\examples{
\donttest{
data(samples_db)

# Infering V pooled deletions
del_db <- deletionsByVpooled(samples_db)
head(del_db)
}
}
