% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_means.R
\name{compare_means}
\alias{compare_means}
\title{Compare sample means}
\usage{
compare_means(
  dataset,
  var1,
  var2,
  samples = "independent",
  alternative = "two.sided",
  conf_lev = 0.95,
  comb = "",
  adjust = "none",
  test = "t",
  data_filter = "",
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset}

\item{var1}{A numeric variable or factor selected for comparison}

\item{var2}{One or more numeric variables for comparison. If var1 is a factor only one variable can be selected and the mean of this variable is compared across (factor) levels of var1}

\item{samples}{Are samples independent ("independent") or not ("paired")}

\item{alternative}{The alternative hypothesis ("two.sided", "greater" or "less")}

\item{conf_lev}{Span of the confidence interval}

\item{comb}{Combinations to evaluate}

\item{adjust}{Adjustment for multiple comparisons ("none" or "bonf" for Bonferroni)}

\item{test}{t-test ("t") or Wilcox ("wilcox")}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}
}
\value{
A list of all variables defined in the function as an object of class compare_means
}
\description{
Compare sample means
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/compare_means.html} for an example in Radiant
}
\examples{
compare_means(diamonds, "cut", "price") \%>\% str()

}
\seealso{
\code{\link{summary.compare_means}} to summarize results

\code{\link{plot.compare_means}} to plot results
}
