% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{dtab.data.frame}
\alias{dtab.data.frame}
\title{Create an interactive table to view, search, sort, and filter data}
\usage{
\method{dtab}{data.frame}(
  object,
  vars = "",
  filt = "",
  rows = NULL,
  nr = NULL,
  na.rm = FALSE,
  dec = 3,
  perc = "",
  filter = "top",
  pageLength = 10,
  dom = "",
  style = "bootstrap",
  rownames = FALSE,
  caption = NULL,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{object}{Data.frame to display}

\item{vars}{Variables to show (default is all)}

\item{filt}{Filter to apply to the specified dataset. For example "price > 10000" if dataset is "diamonds" (default is "")}

\item{rows}{Select rows in the specified dataset. For example "1:10" for the first 10 rows or "n()-10:n()" for the last 10 rows (default is NULL)}

\item{nr}{Number of rows of data to include in the table}

\item{na.rm}{Remove rows with missing values (default is FALSE)}

\item{dec}{Number of decimal places to show. Default is no rounding (NULL)}

\item{perc}{Vector of column names to be displayed as a percentage}

\item{filter}{Show column filters in DT table. Options are "none", "top", "bottom"}

\item{pageLength}{Number of rows to show in table}

\item{dom}{Table control elements to show on the page. See \url{https://datatables.net/reference/option/dom}}

\item{style}{Table formatting style ("bootstrap" or "default")}

\item{rownames}{Show data.frame rownames. Default is FALSE}

\item{caption}{Table caption}

\item{envir}{Environment to extract data from}

\item{...}{Additional arguments}
}
\description{
Create an interactive table to view, search, sort, and filter data
}
\details{
View, search, sort, and filter a data.frame. For styling options see \url{https://rstudio.github.io/DT/functions.html}
}
\examples{
\dontrun{
dtab(mtcars)
}

}
