% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radiant.R
\name{format_nr}
\alias{format_nr}
\title{Format a number with a specified number of decimal places, thousand sep, and a symbol}
\usage{
format_nr(x, sym = "", dec = 2, perc = FALSE, mark = ",", na.rm = TRUE, ...)
}
\arguments{
\item{x}{Number or vector}

\item{sym}{Symbol to use}

\item{dec}{Number of decimals to show}

\item{perc}{Display number as a percentage}

\item{mark}{Thousand separator}

\item{na.rm}{Remove missing values}

\item{...}{Additional arguments passed to \code{\link{formatC}}}
}
\value{
Character (vector) in the desired format
}
\description{
Format a number with a specified number of decimal places, thousand sep, and a symbol
}
\examples{
format_nr(2000, "$")
format_nr(2000, dec = 4)
format_nr(.05, perc = TRUE)
format_nr(c(.1, .99), perc = TRUE)
format_nr(data.frame(a = c(.1, .99)), perc = TRUE)
format_nr(data.frame(a = 1:10), sym = "$", dec = 0)
format_nr(c(1, 1.9, 1.008, 1.00))
format_nr(c(1, 1.9, 1.008, 1.00), drop0trailing = TRUE)
format_nr(NA)
format_nr(NULL)
}
