% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{test_specs}
\alias{test_specs}
\title{Add interaction terms to list of test variables if needed}
\usage{
test_specs(tv, int)
}
\arguments{
\item{tv}{List of variables to use for testing for regress or logistic}

\item{int}{Interaction terms specified}
}
\value{
A vector of variables names to test
}
\description{
Add interaction terms to list of test variables if needed
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/regress.html} for an example in Radiant
}
\examples{
test_specs("a", "a:b")
test_specs("a", c("a:b", "b:c"))
test_specs("a", c("a:b", "b:c", "I(c^2)"))
test_specs(c("a", "b", "c"), c("a:b", "b:c", "I(c^2)"))

}
