% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb.R
\name{nb}
\alias{nb}
\title{Naive Bayes using e1071::naiveBayes}
\usage{
nb(dataset, rvar, evar, laplace = 0, data_filter = "", envir = parent.frame())
}
\arguments{
\item{dataset}{Dataset}

\item{rvar}{The response variable in the logit (probit) model}

\item{evar}{Explanatory variables in the model}

\item{laplace}{Positive double controlling Laplace smoothing. The default (0) disables Laplace smoothing.}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}
}
\value{
A list with all variables defined in nb as an object of class nb
}
\description{
Naive Bayes using e1071::naiveBayes
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/nb.html} for an example in Radiant
}
\examples{
nb(titanic, "survived", c("pclass", "sex", "age")) \%>\% summary()
nb(titanic, "survived", c("pclass", "sex", "age")) \%>\% str()

}
\seealso{
\code{\link{summary.nb}} to summarize results

\code{\link{plot.nb}} to plot results

\code{\link{predict.nb}} for prediction
}
