% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmap.R
\name{summary.pmap}
\alias{summary.pmap}
\title{Summary method for the pmap function}
\usage{
\method{summary}{pmap}(object, cutoff = 0, dec = 2, ...)
}
\arguments{
\item{object}{Return value from \code{\link{pmap}}}

\item{cutoff}{Show only loadings with (absolute) values above cutoff (default = 0)}

\item{dec}{Rounding to use for output}

\item{...}{further arguments passed to or from other methods}
}
\description{
Summary method for the pmap function
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/pmap.html} for an example in Radiant
}
\examples{
result <- pmap("computer","brand","high_end:business")
summary(result)
summary(result, cutoff = .3)
result <- pmap("computer","brand","high_end:dated", pref = c("innovative","business"))
summary(result)
computer \%>\% pmap("brand","high_end:dated", pref = c("innovative","business")) \%>\%
  summary

}
\seealso{
\code{\link{pmap}} to calculate results

\code{\link{plot.pmap}} to plot results
}

