% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pmap.R
\name{pmap}
\alias{pmap}
\title{Attribute based brand maps}
\usage{
pmap(dataset, pmap_brand, pmap_attr, data_filter = "", pmap_pref = "",
  pmap_dim_number = 2)
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{pmap_brand}{A character variable with brand names}

\item{pmap_attr}{Names of numeric variables}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{pmap_pref}{Names of numeric brand preference measures}

\item{pmap_dim_number}{Number of dimensions}
}
\value{
A list of all variables defined in the function as an object of class pmap
}
\description{
Attribute based brand maps
}
\details{
See \url{http://mostly-harmless.github.io/radiant/marketing/pmap.html} for an example in Radiant
}
\examples{
result <- pmap("computer","Brand","HighEnd:Business")
}
\seealso{
\code{\link{summary.pmap}} to summarize results

\code{\link{plot.pmap}} to plot results
}

