% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLCMFeatures.R
\name{glcm_features}
\alias{glcm_features}
\alias{glcm_mean}
\alias{glcm_variance}
\alias{glcm_autoCorrelation}
\alias{glcm_cProminence}
\alias{glcm_cShade}
\alias{glcm_cTendency}
\alias{glcm_contrast}
\alias{glcm_correlation}
\alias{glcm_differenceEntropy}
\alias{glcm_dissimilarity}
\alias{glcm_energy}
\alias{glcm_entropy}
\alias{glcm_homogeneity1}
\alias{glcm_homogeneity2}
\alias{glcm_IDMN}
\alias{glcm_IDN}
\alias{glcm_inverseVariance}
\alias{glcm_maxProb}
\alias{glcm_sumAverage}
\alias{glcm_sumEntropy}
\alias{glcm_sumVariance}
\title{GLCM Features}
\usage{
glcm_mean(glcm)

glcm_variance(glcm)

glcm_autoCorrelation(glcm)

glcm_cProminence(glcm)

glcm_cShade(glcm)

glcm_cTendency(glcm)

glcm_contrast(glcm)

glcm_correlation(glcm)

glcm_differenceEntropy(glcm, base = 2)

glcm_dissimilarity(glcm)

glcm_energy(glcm)

glcm_entropy(glcm, base = 2)

glcm_homogeneity1(glcm)

glcm_homogeneity2(glcm)

glcm_IDMN(glcm)

glcm_IDN(glcm)

glcm_inverseVariance(glcm)

glcm_maxProb(glcm)

glcm_sumAverage(glcm)

glcm_sumEntropy(glcm, base = 2)

glcm_sumVariance(glcm)
}
\arguments{
\item{glcm}{A matrix of class "glcm" produced by \code{glcm}.}

\item{base}{Base of the logarithm in differenceEntropy.}
}
\description{
GLCM Features
}
\section{Functions}{
\itemize{
\item \code{glcm_mean}: Mean

\item \code{glcm_variance}: Variance

\item \code{glcm_autoCorrelation}: Autocorrelation

\item \code{glcm_cProminence}: Cluster Prominence

\item \code{glcm_cShade}: Cluster Shade

\item \code{glcm_cTendency}: Cluster Tendency

\item \code{glcm_contrast}: Contrast

\item \code{glcm_correlation}: Correlation

\item \code{glcm_differenceEntropy}: Difference Entropy

\item \code{glcm_dissimilarity}: Dissimilarity

\item \code{glcm_energy}: Energy

\item \code{glcm_entropy}: Entropy

\item \code{glcm_homogeneity1}: Homogeneity

\item \code{glcm_homogeneity2}: Homogeneity 2

\item \code{glcm_IDMN}: Inverse Difference Moment (Normalized)

\item \code{glcm_IDN}: Inverse Difference (Normalized)

\item \code{glcm_inverseVariance}: Inverse Variance

\item \code{glcm_maxProb}: Maximum Probability

\item \code{glcm_sumAverage}: Sum Average

\item \code{glcm_sumEntropy}: Sum Entropy

\item \code{glcm_sumVariance}: Sum Variance
}}

\references{
\url{http://journals.plos.org/plosone/article?id=10.1371/journal.pone.0102107#s5}
}
