% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{ragnar_retrieve_vss_and_bm25}
\alias{ragnar_retrieve_vss_and_bm25}
\title{Retrieve VSS and BM25}
\usage{
ragnar_retrieve_vss_and_bm25(store, text, top_k = 3, ...)
}
\arguments{
\item{store}{A \code{RagnarStore} object or a \code{dplyr::tbl()} derived from
it. When you pass a \code{tbl}, you may use usual dplyr verbs (e.g.
\code{filter()}, \code{slice()}) to restrict the rows examined before
similarity scoring. Avoid dropping essential columns such as
\code{text}, \code{embedding}, \code{origin}, and \code{hash}.}

\item{text}{A string to find the nearest match too}

\item{top_k}{Integer, the number of entries to retrieve using \strong{per method}.}

\item{...}{Forwarded to \code{\link[=ragnar_retrieve_vss]{ragnar_retrieve_vss()}}}
}
\value{
A dataframe of retrieved chunks. Each row corresponds to an
individual chunk in the store. It always contains a column named \code{text}
that contains the chunks.
}
\description{
Runs \code{\link[=ragnar_retrieve_vss]{ragnar_retrieve_vss()}} and \code{\link[=ragnar_retrieve_bm25]{ragnar_retrieve_bm25()}} and get the distinct
documents.
}
\note{
The results are not re-ranked after identifying the unique values.
}
\section{Pre-filtering with dplyr}{

The store behaves like a lazy table backed by DuckDB, so row‑wise
filtering is executed directly in the database. This lets you narrow the
search space efficiently without pulling data into R.
}

\examples{
\dontshow{if ((rlang::is_installed("dbplyr") && nzchar(Sys.getenv("OPENAI_API_KEY")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Basic usage
store <- ragnar_store_create(
  embed = \(x) ragnar::embed_openai(x, model = "text-embedding-3-small")
)
ragnar_store_insert(store, data.frame(text = c("foo", "bar")))
ragnar_store_build_index(store)
ragnar_retrieve(store, "foo")

# More Advanced: store metadata, retrieve with pre-filtering
store <- ragnar_store_create(
  embed = \(x) ragnar::embed_openai(x, model = "text-embedding-3-small"),
  extra_cols = data.frame(category = character())
)

ragnar_store_insert(
  store,
  data.frame(
    category = "desert",
    text = c("ice cream", "cake", "cookies")
  )
)

ragnar_store_insert(
  store,
  data.frame(
    category = "meal",
    text = c("steak", "potatoes", "salad")
  )
)

ragnar_store_build_index(store)

# simple retrieve
ragnar_retrieve(store, "carbs")

# retrieve with pre-filtering
dplyr::tbl(store) |>
  dplyr::filter(category == "meal") |>
  ragnar_retrieve("carbs")
\dontshow{\}) # examplesIf}
}
\seealso{
Other ragnar_retrieve: 
\code{\link{ragnar_retrieve}()},
\code{\link{ragnar_retrieve_bm25}()},
\code{\link{ragnar_retrieve_vss}()}
}
\concept{ragnar_retrieve}
