\name{momentS}
\alias{momentS}
\title{
Moments of the sample covariance matrix.
}
\description{
Calculates the moments of the sample covariance matrix. It assumes that the summands (the outer products of the samples' random data vector) that constitute the sample covariance matrix follow a Wishart-distribution with scale parameter \eqn{\mathbf{\Sigma}} and shape parameter \eqn{\nu}. The latter is equal to the number of summands in the sample covariance estimate.
}
\usage{
momentS(Sigma, shape, moment=1)
}
\arguments{
\item{Sigma}{ Positive-definite \code{matrix}, the scale parameter \eqn{\mathbf{\Sigma}} of the Wishart distribution. }
\item{shape}{ A \code{numeric}, the shape parameter \eqn{\nu} of the Wishart distribution. Should exceed the number of variates (number of rows or columns of \code{Sigma}). }
\item{moment}{ An \code{integer}. Should be in the set \eqn{\{-4, -3, -2, -1, 0, 1, 2, 3, 4\}} (only those are explicitly specified in Lesac, Massam, 2004). }
}
\value{
The \eqn{r}-th moment of a sample covariance matrix: \eqn{E(\mathbf{S}^r)}.
}
\references{
Lesac, G., Massam, H. (2004), "All invariant moments of the Wishart distribution", \emph{Scandinavian Journal of Statistics}, 31(2), 295-318.
}
\author{
Wessel N. van Wieringen<w.vanwieringen@vumc.nl>.
}
\examples{
# create scale parameter
Sigma <- matrix(c(1, 0.5, 0, 0.5, 1, 0, 0, 0, 1), byrow=TRUE, ncol=3)

# evaluate expectation of the square of a sample covariance matrix 
# that is assumed to Wishart-distributed random variable with the 
# above scale parameter Sigma and shape parameter equal to 40.
momentS(Sigma, 40, 2)
}

