% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainette2.R
\name{rainette2}
\alias{rainette2}
\title{Corpus clustering based on the Reinert method - Double clustering}
\usage{
rainette2(
  x,
  y = NULL,
  max_k = 5,
  uc_size1 = 10,
  uc_size2 = 15,
  min_members = 10,
  min_chi2 = 3.84,
  ...
)
}
\arguments{
\item{x}{either a quanteda dfm object or the result of \code{\link[=rainette]{rainette()}}}

\item{y}{if \code{x} is a \code{\link[=rainette]{rainette()}} result, this must be another \code{\link[=rainette]{rainette()}} result from same dfm
but with different uc size.}

\item{max_k}{maximum number of clusters to compute}

\item{uc_size1}{if \code{x} is a dfm, minimum uc size for first clustering}

\item{uc_size2}{if \code{x} is a dfm, minimum uc size for second clustering}

\item{min_members}{minimum members of each cluster}

\item{min_chi2}{minimum chi2 for each cluster}

\item{...}{if \code{x} is a dfm object, parameters passed to \code{\link[=rainette]{rainette()}} for both
simple clusterings}
}
\value{
A tibble with optimal partitions found for each available value of \code{k} as rows, and the following
columns :
\itemize{
\item \code{clusters} list of the crossed original clusters used in the partition
\item \code{k} the number of clusters
\item \code{chi2} sum of the chi2 value of each cluster
\item \code{n} sum of the size of each cluster
\item \code{groups} group membership of each document for this partition (\code{NA} if not assigned)
}
}
\description{
Corpus clustering based on the Reinert method - Double clustering
}
\details{
You can pass a quanteda dfm as \code{x} object, the function then performs two simple
clustering with varying minimum uc size, and then proceed to find optimal partitions
based on the results of both clusterings.

If both clusterings have already been computed, you can pass them as \code{x} and \code{y} arguments
and the function will only look for optimal partitions.

For more details on optimal partitions search algorithm, please see package vignettes.
}
\examples{
\donttest{
mini_corpus <- head(data_corpus_inaugural, n = 2)
mini_corpus <- split_segments(mini_corpus, 5)
dtm <- dfm(mini_corpus, remove = stopwords("en"), tolower = TRUE, remove_punct = TRUE)
dtm <- dfm_wordstem(dtm, language = "english")
dtm <- dfm_trim(dtm, min_termfreq = 3)

res1 <- rainette(dtm, k = 5, min_uc_size = 2, min_split_members = 2)
res2 <- rainette(dtm, k = 5, min_uc_size = 3, min_split_members = 2)

res <- rainette2(res1, res2, min_members = 2)
rainette2_explor(res, dtm)
}
}
\references{
\itemize{
\item Reinert M, Une méthode de classification descendante hiérarchique : application à l'analyse lexicale par contexte, Cahiers de l'analyse des données, Volume 8, Numéro 2, 1983. \url{http://www.numdam.org/item/?id=CAD_1983__8_2_187_0}
\item Reinert M., Alceste une méthodologie d'analyse des données textuelles et une application: Aurelia De Gerard De Nerval, Bulletin de Méthodologie Sociologique, Volume 26, Numéro 1, 1990. \url{https://doi.org/10.1177/075910639002600103}
}
}
\seealso{
\code{\link[=rainette]{rainette()}}, \code{\link[=cutree_rainette2]{cutree_rainette2()}}, \code{\link[=rainette2_plot]{rainette2_plot()}}, \code{\link[=rainette2_explor]{rainette2_explor()}}
}
