% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rake_functions.R
\name{integerise}
\alias{integerise}
\title{integerise}
\usage{
integerise(weights, method = "trs")
}
\arguments{
\item{weights}{A matrix or data frame of fractional weights, typically
provided by \code{weight()}}

\item{method}{The integerisation method specified as a character string.
Defaults to \code{"trs"}.}
}
\value{
A data frame of integerised weights to be used by \code{simulate()}
}
\description{
Generate integer cases from numeric weights matrix.
}
\details{
The default integerisation method uses the 'truncate, replicate, sample'
method developed by Robin Lovelace and Dimitris Ballas
\url{http://www.sciencedirect.com/science/article/pii/S0198971513000240}

Other methods (for example proportional probabilities) may be implemented
at a later date.
}
\examples{
cons <- data.frame(
  "zone"   = letters[1:3],
  "a0_49"  = c(8, 2, 7),
  "a_gt50" = c(4, 8, 4),
  "f"      = c(6, 6, 8),
  "m"      = c(6, 4, 3)
)

inds <- data.frame(
  "id"     = LETTERS[1:5],
  "age"    = c("a_gt50", "a_gt50", "a0_49", "a_gt50", "a0_49"),
  "sex"    = c("m", "m", "m", "f", "f"),
  "income" = c(2868, 2474, 2231, 3152, 2473),
  stringsAsFactors = FALSE
)
vars <- c("age", "sex")

weights     <- weight(cons = cons, inds = inds, vars = vars)
weights_int <- integerise(weights)
weights_int
}

