% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{td_auth_refreshToken}
\alias{td_auth_refreshToken}
\title{Auth Step 2: Obtain Refresh Token}
\usage{
td_auth_refreshToken(consumerKey, callbackURL, codeToken)
}
\arguments{
\item{consumerKey}{TD generated Consumer key for the registered TD app.
Essentially an API key.}

\item{callbackURL}{User generated Callback URL for the registered TD app}

\item{codeToken}{Will be either an authorization code when manually logging
in or a Refresh Token if the current Refresh Token is nearing expiration.}
}
\value{
Refresh Token that is valid for 90 days
}
\description{
Get a Refresh Token using the Authorization Code or an existing Refresh Token
}
\details{
Once a URL has been generated using \code{\link{td_auth_loginURL}}, a user
can visit that URL to log into a TD brokerage account, granting the TD app
access to the account. Once the button "Allow" is pressed, the user will be
redirected, potentially to "This site can't be reached". This indicates a
successful log in. The URL of this page contains the Authorization Code.
Paste the entire URL, not just the Authorization Code, into
td_auth_refreshToken. The authorization code will be an extremely long alpha
numeric string starting with 'https'.

The output of td_auth_refreshToken will be a Refresh Token which will be used
to gain access to the TD Brokerage account(s) going forward. The Refresh
Token will be valid for 90 days. Be sure to save the Refresh Token to a safe
location or the manual log in process will be required again. The user can use
td_auth_refreshToken to reset the token before expiration.

The Refresh Token output should be saved in a very safe location, but also
accessible. It will be needed to generate an Access Token using
\code{\link{td_auth_accessToken}}, which is used for general account access.
The Access Token expires after 30 minutes.

Note: When running this function interactively (e.g. through RStudio) using
an existing Refresh Token, the function will check the days left until
expiration for the Refresh Token being passed. If the remaining time is
greater than 15 days, the user will be prompted to verify that a new Refresh
Token should be created. The user can select to request a new token, but
there is no net benefit in doing so and TD encourages limiting new token
generation. When running this function in a non-interactive environment (e.g.
CRON Job), if the remaining time until expiration is greater than 15 days,
the default behavior will be to NOT reset the Refresh Token because the new
token will have the same access and capabilities as the existing token.
}
\examples{
\dontrun{

# Initial access will require manually logging in to the URL from td_auth_loginURL
# After a successful log in, the URL authorization code can be fed with a callbackURL
refreshToken = td_auth_refreshToken(consumerKey = 'TD_CONSUMER_KEY',
                                    callbackURL = 'https://myTDapp',
                                    codeToken = 'https://myTDapp/?code=Auhtorizationcode')

# If an existing Refresh Token exists. Pass this. CallbackURL is not needed.
refreshToken = readRDS('/secure/location/')
refreshToken = td_auth_refreshToken(consumerKey = 'TD_CONSUMER_KEY',
                                    codeToken = refreshToken)

# Save the Refresh Token somewhere safe where it can be retrieved
saveRDS(refreshToken,'/secure/location/')

}
}
\seealso{
\code{\link{td_auth_loginURL}} to generate a login url which leads
  to an authorization code, \code{\link{td_auth_refreshToken}} to generate a
  Refresh Token using an existing Refresh Token or an authorization code with
  a callback URL when logging in manually,  \code{\link{td_auth_accessToken}}
  to generate a new Access Token
}
