/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.variables;

import eu.amidst.core.distribution.BaseDistribution_MultinomialParents;
import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.ConditionalLinearGaussian;
import eu.amidst.core.distribution.Multinomial;
import eu.amidst.core.distribution.Multinomial_MultinomialParents;
import eu.amidst.core.distribution.Normal;
import eu.amidst.core.distribution.Normal_MultinomialNormalParents;
import eu.amidst.core.distribution.Normal_MultinomialParents;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.distributionTypes.DirichletParameterType;
import eu.amidst.core.variables.distributionTypes.GammaParameterType;
import eu.amidst.core.variables.distributionTypes.IndicatorType;
import eu.amidst.core.variables.distributionTypes.InverseGammaParameterType;
import eu.amidst.core.variables.distributionTypes.MultinomialLogisticType;
import eu.amidst.core.variables.distributionTypes.MultinomialType;
import eu.amidst.core.variables.distributionTypes.NormalGammaParameterType;
import eu.amidst.core.variables.distributionTypes.NormalParameterType;
import eu.amidst.core.variables.distributionTypes.NormalType;
import eu.amidst.core.variables.distributionTypes.SparseDirichletParameterType;
import eu.amidst.core.variables.distributionTypes.SparseMultinomialType;
import eu.amidst.core.variables.distributionTypes.TruncatedExponentialType;

public enum DistributionTypeEnum {
    MULTINOMIAL,
    NORMAL,
    MULTINOMIAL_LOGISTIC,
    NORMAL_PARAMETER,
    INV_GAMMA_PARAMETER,
    GAMMA_PARAMETER,
    DIRICHLET_PARAMETER,
    NORMAL_GAMMA_PARAMETER,
    TRUNCATED_EXPONENTIAL,
    SPARSE_MULTINOMIAL,
    SPARSE_DIRICHLET_PARAMETER,
    INDICATOR;


    public <E extends DistributionType> E newDistributionType(Variable var) {
        switch (this) {
            case MULTINOMIAL: {
                return (E)new MultinomialType(var);
            }
            case NORMAL: {
                return (E)new NormalType(var);
            }
            case MULTINOMIAL_LOGISTIC: {
                return (E)new MultinomialLogisticType(var);
            }
            case NORMAL_PARAMETER: {
                return (E)new NormalParameterType(var);
            }
            case INV_GAMMA_PARAMETER: {
                return (E)new InverseGammaParameterType(var);
            }
            case GAMMA_PARAMETER: {
                return (E)new GammaParameterType(var);
            }
            case DIRICHLET_PARAMETER: {
                return (E)new DirichletParameterType(var);
            }
            case NORMAL_GAMMA_PARAMETER: {
                return (E)new NormalGammaParameterType(var);
            }
            case TRUNCATED_EXPONENTIAL: {
                return (E)new TruncatedExponentialType(var);
            }
            case SPARSE_MULTINOMIAL: {
                return (E)new SparseMultinomialType(var);
            }
            case SPARSE_DIRICHLET_PARAMETER: {
                return (E)new SparseDirichletParameterType(var);
            }
            case INDICATOR: {
                return (E)new IndicatorType(var);
            }
        }
        throw new IllegalArgumentException("Unknown Distribution Type");
    }

    public static <E extends ConditionalDistribution> E FromBaseDistributionToConditionalDistribution(BaseDistribution_MultinomialParents base) {
        if (base.getBaseDistribution(0) instanceof Multinomial) {
            return (E)new Multinomial_MultinomialParents(base);
        }
        if (base.getBaseDistribution(0) instanceof Normal && base.getConditioningVariables().size() > 0) {
            return (E)new Normal_MultinomialParents(base);
        }
        if (base.getBaseDistribution(0) instanceof ConditionalLinearGaussian) {
            return (E)new Normal_MultinomialNormalParents(base);
        }
        return (E)base;
    }
}

