/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.learning.parametric;

import com.google.common.util.concurrent.AtomicDouble;
import eu.amidst.core.datastream.DataOnMemory;
import eu.amidst.core.datastream.DataStream;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.dynamic.datastream.DynamicDataInstance;
import eu.amidst.dynamic.exponentialfamily.EF_DynamicBayesianNetwork;
import eu.amidst.dynamic.learning.parametric.ParameterLearningAlgorithm;
import eu.amidst.dynamic.models.DynamicBayesianNetwork;
import eu.amidst.dynamic.models.DynamicDAG;
import java.util.stream.Stream;

public class ParallelMaximumLikelihood
implements ParameterLearningAlgorithm {
    protected int windowsSize = 1000;
    protected boolean parallelMode = true;
    protected DataStream<DynamicDataInstance> dataStream;
    protected DynamicDAG dag;
    protected AtomicDouble dataInstanceCount;
    protected SufficientStatistics sumSS;
    protected EF_DynamicBayesianNetwork efBayesianNetwork;
    protected boolean debug = true;
    protected boolean laplace = true;

    public void setLaplace(boolean laplace) {
        this.laplace = laplace;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void setWindowsSize(int windowsSize) {
    }

    @Override
    public int getWindowsSize() {
        return this.windowsSize;
    }

    @Override
    public void initLearning() {
        this.efBayesianNetwork = new EF_DynamicBayesianNetwork(this.dag);
        if (this.laplace) {
            this.sumSS = this.efBayesianNetwork.createInitSufficientStatistics();
            this.dataInstanceCount = new AtomicDouble(1.0);
        } else {
            this.sumSS = this.efBayesianNetwork.createZeroSufficientStatistics();
            this.dataInstanceCount = new AtomicDouble(0.0);
        }
    }

    @Override
    public double updateModel(DataOnMemory<DynamicDataInstance> batch) {
        this.sumSS.sum(batch.stream().map(this.efBayesianNetwork::getSufficientStatistics).reduce(SufficientStatistics::sumVectorNonStateless).get());
        this.dataInstanceCount.addAndGet(batch.getNumberOfDataInstances());
        return Double.NaN;
    }

    @Override
    public void setDataStream(DataStream<DynamicDataInstance> data) {
        this.dataStream = data;
    }

    @Override
    public double getLogMarginalProbability() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Override
    public double updateModel(DataStream<DynamicDataInstance> dataStream) {
        Stream<DataOnMemory<DynamicDataInstance>> stream = null;
        stream = this.parallelMode ? dataStream.parallelStreamOfBatches(this.windowsSize) : dataStream.streamOfBatches(this.windowsSize);
        this.sumSS.sum(stream.peek(batch -> {
            this.dataInstanceCount.getAndAdd(batch.getNumberOfDataInstances());
            if (this.debug) {
                System.out.println("Parallel ML procesando " + (int)this.dataInstanceCount.get() + " instances");
            }
        }).map(batch -> batch.stream().map(this.efBayesianNetwork::getSufficientStatistics).reduce(SufficientStatistics::sumVectorNonStateless).get()).reduce(SufficientStatistics::sumVectorNonStateless).get());
        return Double.NaN;
    }

    @Override
    public void runLearning() {
        this.initLearning();
        Stream<DataOnMemory<DynamicDataInstance>> stream = null;
        stream = this.parallelMode ? this.dataStream.parallelStreamOfBatches(this.windowsSize) : this.dataStream.streamOfBatches(this.windowsSize);
        this.sumSS.sum(stream.peek(batch -> {
            this.dataInstanceCount.getAndAdd(batch.getNumberOfDataInstances());
            if (this.debug) {
                System.out.println("Parallel ML procesando " + (int)this.dataInstanceCount.get() + " instances");
            }
        }).map(batch -> batch.stream().map(this.efBayesianNetwork::getSufficientStatistics).reduce(SufficientStatistics::sumVectorNonStateless).get()).reduce(SufficientStatistics::sumVectorNonStateless).get());
    }

    @Override
    public void setDynamicDAG(DynamicDAG dag_) {
        this.dag = dag_;
    }

    @Override
    public void setSeed(int seed) {
    }

    @Override
    public DynamicBayesianNetwork getLearntDBN() {
        SufficientStatistics normalizedSS = this.efBayesianNetwork.createZeroSufficientStatistics();
        normalizedSS.copy(this.sumSS);
        normalizedSS.divideBy(this.dataInstanceCount.get());
        this.efBayesianNetwork.setMomentParameters(normalizedSS);
        return this.efBayesianNetwork.toDynamicBayesianNetwork(this.dag);
    }

    @Override
    public void setParallelMode(boolean parallelMode_) {
        this.parallelMode = parallelMode_;
    }

    @Override
    public void setOutput(boolean activateOutput) {
    }
}

