% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chronBias.R
\name{chronBias}
\alias{chronBias}
\title{Representing chronological bias}
\usage{
chronBias(type, theta, method, saltus, alpha = 0.05)
}
\arguments{
\item{type}{character string, should be one of "\code{linT}", "\code{logT}", or "\code{stepT}", 
see Details.}

\item{theta}{factor of the time trend for further details see \code{type}.}

\item{method}{character string, should be one of \code{"sim"} or \code{"exact"}, see Description.}

\item{saltus}{integer or  \code{missing} specifying the patient index (i.e. position)
of the step in case of step time trend.}

\item{alpha}{significance level}
}
\value{
\code{S4} object of class \code{chronBias}, a formal representation of the
issue of chronological bias in a clinical trial.
}
\description{
Represents the issue of chronological bias in a clinical trial.
}
\details{
Chronological bias can be an issue in the design of a clinical trial. The 
\code{chronBias} function is a constructor function
for an S4 object of the class \code{chronBias} representing the issue of
chronological bias, s.a. time trends, in a clinical trial. It supports two possible modes,
\code{method="sim"} and \code{method="exact"}, and three different types of trend. 

If \code{method="sim"}, the object represents the simulated type-I-error rate given 
 the level \code{alpha}, the selection effect \code{eta} and the biasing 
 strategy \code{type}. When calling \code{assess} for a \code{chronBias} object 
 with \code{method="sim"}, one test decision is computed for each sequence of
\code{randSeq}. The type-I-error rate (power) is the proportion of falsely
(correctly) rejected null hypotheses.

If \code{method="exact"}, the object represents the exact type-I-error proabability 
 given the level \code{alpha}, the selection effect \code{eta} and the 
 biasing strategy \code{type}. When calling \code{assess} for a \code{chronBias} 
 object with \code{method="exact"}, the exact \emph{p}-value of each 
 randomization sequence is computed. So far, this is only supported for
 normal endpoints. Then the type-I-error probability is
 the sum of the corresponding quantiles of the doubly noncentral t-distribution.

\subsection{Types of chronological bias}{
\describe{
	 \item{\code{type = "linT"}}{
   Represents linear time trend. Linear time trend means that the expected response
	  of the patients increases evenly by \code{theta} with 
   every patient included in the study, until reaching \code{N theta} after \code{N} patients.
   Linear time trend may occur as a result of gradually relaxing in- or exlusion criteria 
   throughout the trial.
   It can be presented by the formula: \deqn{f(i) = i  \theta}{f(i) = i \theta}
  }
	 \item{\code{type = "logT"}}{
   Represents logistic time trend. Logistic time trend means that the expected response
	  of the patients increases logistically in the patient index by \code{theta} with 
   every patient included in the study, until reaching \code{log(N) theta} after \code{N} patients.
   Logistic time trend may occur as a result of a learning curve, i.e. in a surgical trial.
   It can be presented by the formula:
  \deqn{\log(i) \theta}{f(i) = log(i/N) \theta}
  }
	 \item{\code{type = "stepT"}}{
   Represents step trend. Step trend means that the expected response of the patients increases
   by \code{theta} after a given point (\code{"saltus"}) in the allocation process.
   Step trend may occur if a new device is used after the point \eqn{c} = \code{"saltus"}, or if 
   the medical personal changes after after this point.
   Step time trend can be presented by the formula:
  \deqn{f(i) = 1_{c \leq i \leq N} \theta}{f(i) = 1_{c \le i\le N} \theta }
  }
}
}
}
\references{
G. K. Rosenkranz (2011) The impact of randomization on the analysis of
clinical trials. \emph{Statistics in Medicine}, \strong{30}, 3475-87. 

M. Tamm and R.-D. Hilgers (2014) Chronological bias in randomized clinical 
trials under different types of unobserved time trends. 
\emph{Methods of Information in Medicine}, \strong{53}, 501-10.
}
\seealso{
Other issues: \code{\link{combineBias}},
  \code{\link{corGuess}}, \code{\link{imbal}},
  \code{\link{issue}}, \code{\link{selBias}},
  \code{\link{setPower}}
}

