% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_and_cluster_ra.R
\name{block_and_cluster_ra_probabilities}
\alias{block_and_cluster_ra_probabilities}
\title{probabilities of assignment: Blocked and Clustered Random Assignment}
\usage{
block_and_cluster_ra_probabilities(blocks = NULL, clusters = NULL,
  prob = NULL, prob_each = NULL, m = NULL, block_m = NULL,
  block_m_each = NULL, block_prob = NULL, block_prob_each = NULL,
  num_arms = NULL, conditions = NULL, check_inputs = TRUE)
}
\arguments{
\item{blocks}{A vector of length N that indicates which block each unit belongs to.}

\item{clusters}{A vector of length N that indicates which cluster each unit belongs to.}

\item{prob}{Use for a two-arm design in which either floor(N_clusters_block*prob) or ceiling(N_clusters_block*prob) clusters are assigned to treatment within each block. The probability of assignment to treatment is exactly prob because with probability 1-prob, floor(N_clusters_block*prob) clusters will be assigned to treatment and with probability prob, ceiling(N_clusters_block*prob) clusters will be assigned to treatment. prob must be a real number between 0 and 1 inclusive. (optional)}

\item{prob_each}{Use for a multi-arm design in which the values of prob_each determine the probabilities of assignment to each treatment condition. prob_each must be a numeric vector giving the probability of assignment to each condition. All entries must be nonnegative real numbers between 0 and 1 inclusive and the total must sum to 1. Because of integer issues, the exact number of clusters assigned to each condition may differ (slightly) from assignment to assignment, but the overall probability of assignment is exactly prob_each. (optional)}

\item{m}{Use for a two-arm design in which the scalar m describes the fixed number of clusters assigned in each block. This number does not vary across blocks.}

\item{block_m}{Use for a two-arm design in which block_m describes the number of clusters to assign to treatment within each block. block_m must be a numeric vector that is as long as the number of blocks and is in the same order as sort(unique(blocks)).}

\item{block_m_each}{Use for a multi-arm design in which the values of block_m_each determine the number of clusters assigned to each condition. block_m_each must be a matrix with the same number of rows as blocks and the same number of columns as treatment arms. Cell entries are the number of clusters to be assigned to each treatment arm within each block. The rows should respect the ordering of the blocks as determined by sort(unique(blocks)). The columns should be in the order of conditions, if specified.}

\item{block_prob}{Use for a two-arm design in which block_prob describes the probability of assignment to treatment within each block. Must be in the same order as sort(unique(blocks)). Differs from prob in that the probability of assignment can vary across blocks.}

\item{block_prob_each}{Use for a multi-arm design in which the values of block_prob_each determine the probabilities of assignment to each treatment condition. block_prob_each must be a matrix with the same number of rows as blocks and the same number of columns as treatment arms. Cell entries are the probabilities of assignment to treatment within each block. The rows should respect the ordering of the blocks as determined by sort(unique(blocks)). Use only if the probabilities of assignment should vary by block, otherwise use prob_each. Each row of block_prob_each must sum to 1.}

\item{num_arms}{The number of treatment arms. If unspecified, num_arms will be determined from the other arguments. (optional)}

\item{conditions}{A character vector giving the names of the treatment groups. If unspecified, the treatment groups will be named 0 (for control) and 1 (for treatment) in a two-arm trial and T1, T2, T3, in a multi-arm trial. An exception is a two-group design in which num_arms is set to 2, in which case the condition names are T1 and T2, as in a multi-arm trial with two arms. (optional)}

\item{check_inputs}{logical. Defaults to TRUE.}
}
\value{
A matrix of probabilities of assignment
}
\description{
probabilities of assignment: Blocked and Clustered Random Assignment
}
\examples{

clusters <- rep(letters, times=1:26)
blocks <- rep(NA, length(clusters))
blocks[clusters \%in\% letters[1:5]] <- "block_1"
blocks[clusters \%in\% letters[6:10]] <- "block_2"
blocks[clusters \%in\% letters[11:15]] <- "block_3"
blocks[clusters \%in\% letters[16:20]] <- "block_4"
blocks[clusters \%in\% letters[21:26]] <- "block_5"


prob_mat <- block_and_cluster_ra_probabilities(clusters = clusters,
                                               blocks = blocks)
head(prob_mat)
                                    
prob_mat <- block_and_cluster_ra_probabilities(clusters = clusters,
                                               blocks = blocks,
                                               num_arms = 3)
head(prob_mat)
                                    
prob_mat <- block_and_cluster_ra_probabilities(clusters = clusters,
                                               blocks = blocks,
                                               prob_each = c(.2, .5, .3))
head(prob_mat)                                    

block_m_each <- rbind(c(2, 3),
                      c(1, 4),
                      c(3, 2),
                      c(2, 3),
                      c(5, 1))

prob_mat <- block_and_cluster_ra_probabilities(clusters = clusters, 
                                               blocks = blocks, 
                                               block_m_each = block_m_each)
head(prob_mat)                                    


}
