% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_rs.R
\name{cluster_rs_probabilities}
\alias{cluster_rs_probabilities}
\title{Inclusion Probabilities: Cluster Sampling}
\usage{
cluster_rs_probabilities(
  clusters = NULL,
  n = NULL,
  n_unit = NULL,
  prob = NULL,
  prob_unit = NULL,
  simple = FALSE,
  check_inputs = TRUE
)
}
\arguments{
\item{clusters}{A vector of length N that indicates which cluster each unit belongs to.}

\item{n}{Use for a design in which n clusters are sampled. (optional)}

\item{n_unit}{unique(n_unit) will be passed to \code{n}. Must be the same for all units (optional)}

\item{prob}{Use for a design in which either floor(N_clusters*prob) or ceiling(N_clusters*prob) clusters are sampled. The probability of being sampled is exactly prob because with probability 1-prob, floor(N_clusters*prob) clusters will be sampled and with probability prob, ceiling(N_clusters*prob) clusters will be sampled. prob must be a real number between 0 and 1 inclusive. (optional)}

\item{prob_unit}{unique(prob_unit) will be passed to the prob argument and must be the same for all units.}

\item{simple}{logical, defaults to FALSE. If TRUE, simple random sampling of clusters. When simple = TRUE, please do not specify n.}

\item{check_inputs}{logical. Defaults to TRUE.}
}
\value{
A vector length N indicating the probability of being sampled.
}
\description{
Inclusion Probabilities: Cluster Sampling
}
\examples{

# Two Group Designs
clusters <- rep(letters, times = 1:26)
probs <- cluster_rs_probabilities(clusters = clusters)
table(probs, clusters)

prob_mat <- cluster_rs_probabilities(clusters = clusters, n = 10)
table(probs, clusters)

prob_mat <- cluster_rs_probabilities(clusters = clusters, prob = .3)
table(probs, clusters)


}
