% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeInfo.R
\name{treeInfo}
\alias{treeInfo}
\title{Tree information in human readable format}
\usage{
treeInfo(object, tree = 1)
}
\arguments{
\item{object}{\code{ranger} object.}

\item{tree}{Number of the tree of interest.}
}
\value{
A data.frame with the columns
\tabular{ll}{
      \code{nodeID} \tab The nodeID, 0-indexed. \cr
      \code{leftChild} \tab ID of the left child node, 0-indexed. \cr
      \code{rightChild} \tab ID of the right child node, 0-indexed. \cr
      \code{splitvarID} \tab ID of the splitting variable, 0-indexed. Caution, the variable order changes if the formula interface is used. \cr
      \code{splitvarName} \tab Name of the splitting variable. \cr
      \code{splitval} \tab The splitting value. For numeric or ordinal variables, all values smaller or equal go to the left, larger values to the right. For unordered factor variables see above. \cr
      \code{terminal} \tab Logical, TRUE for terminal nodes. \cr
      \code{prediction} \tab One column with the predicted class (factor) for classification and the predicted numerical value for regression. One probability per class for probability estimation in several columns. Nothing for survival, refer to \code{object$forest$chf} for the CHF node predictions. \cr
  }
}
\description{
Extract tree information of a \code{ranger} object.
}
\details{
Node and variable ID's are 0-indexed, i.e., node 0 is the root node. 
If the formula interface is used in the \code{ranger} call, the variable ID's are usually different to the original data used to grow the tree. 
Refer to the variable name instead to be sure.

Splitting at unordered factors (nominal variables) depends on the option \code{respect.unordered.factors} in the \code{ranger} call. 
For the "ignore" and "order" approaches, all values smaller or equal the \code{splitval} value go to the left and all values larger go to the right, as usual. 
However, with "order" the values correspond to the order in \code{object$forest$covariate.levels} instead of the original order (usually alphabetical).
In the "partition" mode, the \code{splitval} values for unordered factor are comma separated lists of values, representing the factor levels (in the original order) going to the left.
}
\examples{
require(ranger)
rf <- ranger(Species ~ ., data = iris)
treeInfo(rf, 1)
}
\seealso{
\code{\link{ranger}}
}
\author{
Marvin N. Wright
}
