% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexIntervals.R
\name{indexIntervals}
\alias{indexIntervals}
\title{Generate index intervals for a set of intervals}
\usage{
indexIntervals(intervals)
}
\arguments{
\item{intervals}{data frame (see \link{generateIntervals} for
the required format)}
}
\value{
data frame (see \link{generateIntervals} for
the format)
}
\description{
If we pick one point from each of a set of intervals, the index intervals
describe the possible ranks of points in each interval.  If this function is
given simultaneous 100(1 - alpha)\% confidence intervals for a distinct set
of parameters, the index intervals are simultaneous 100(1 - alpha)\%
confidence intervals for the true ranks.
}
\details{
See section 5.2 of Rising (2021).
}
\examples{
left <- 0:2 * 0.5 + 1
right <- left + 0.75
intervals <- data.frame(left = left, right = right)
indexIntervals(intervals)
}
\references{
Rising, Justin (2021).  \emph{Uncertainty in Ranking}.  arXiv:2107.03459.
}
