/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.ext;

import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.ext.ExtensionNotLoadedException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiExtensionLoader
implements BundleActivator {
    private static OSGiExtensionLoader instance;
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        instance = this;
        this.context = context;
        ExtensionLoader.setOSGiAvailable();
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T getExtension(Class<T> clazz, String id) {
        Filter filter;
        if (this.context == null) {
            throw new IllegalStateException("OpenNLP Tools Bundle is not active!");
        }
        try {
            filter = FrameworkUtil.createFilter((String)("(&(objectclass=" + clazz.getName() + ")(" + "opennlp" + "=" + id + "))"));
        }
        catch (InvalidSyntaxException e) {
            throw new ExtensionNotLoadedException(e);
        }
        Object extension = null;
        try (ServiceTracker extensionTracker = new ServiceTracker(this.context, filter, null);){
            extensionTracker.open();
            try {
                extension = extensionTracker.waitForService(30000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (extension == null) {
            throw new ExtensionNotLoadedException("No suitable extension found. Extension name: " + id);
        }
        return (T)extension;
    }

    static OSGiExtensionLoader getInstance() {
        return instance;
    }
}

