% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcBoundaryData.R
\name{calcBoundaryData}
\alias{calcBoundaryData}
\alias{calcBoundaryData.PolySet}
\alias{calcBoundaryData.SpatialPolygons}
\title{Calculate boundary data for planning units}
\usage{
calcBoundaryData(x, tol, length.factor, edge.factor)

\method{calcBoundaryData}{PolySet}(x, tol = 0.001, length.factor = 1,
  edge.factor = 1)

\method{calcBoundaryData}{SpatialPolygons}(x, tol = 0.001,
  length.factor = 1, edge.factor = 1)
}
\arguments{
\item{x}{\code{PolySet}, \code{SpatialPolygons} or \code{SpatialPolyognsDataFrame} object.}

\item{tol}{\code{numeric} to specify precision of calculations (that is, how far apart do vertices have to be to be considered different).}

\item{length.factor}{\code{numeric} to scale boundary lengths.}

\item{edge.factor}{\code{numeric} to scale boundary lengths for edges that do not have any neighbors, such as those that occur along the margins.}

\item{...}{not used.}
}
\value{
\code{data.frame} with 'id1' (\code{integer}), 'id2' (\code{integer}), and 'amount' (\code{numeric}) columns.
}
\description{
This function calculates boundary length data for \code{PolySet}, \code{SpatialPolygons}, and \code{SpatialPolygonsDataFrame} objects.
Be aware that this function is designed to be as fast as possible, and as a consequence, if this
function is used improperly then it may crash R. Furthermore, multipart polygons with touching edges will likely result in inaccuracies.
If argument set to \code{SpatialPolygons} or \code{SpatialPolygonsDataFrame}, this will be converted to PolySet before processing.
}
\examples{
# simulate planning units
sim_pus <- sim.pus(225L)
# calculate boundary data
bound.dat <- calcBoundaryData(sim_pus)
summary(bound.dat)
}
\seealso{
This function is based on the algorithm in QMARXAN \url{https://github.com/tsw-apropos/qmarxan} for calculating boundary length.
}

