% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rashnuBasic.R
\name{rashnuBasic}
\alias{rashnuBasic}
\title{Interactive Sample Size Calculator for Survival Studies (Shiny App)}
\usage{
rashnuBasic()
}
\value{
Launches a Shiny app in the default browser.
}
\description{
Launches a Shiny web application that calculates required sample sizes and expected event numbers for different types
of survival analysis designs:
\itemize{
\item Two-group Non-Inferiority
\item Two-group Superiority (Lakatos method)
\item One-sample survival test (with transformation methods)
}
}
\details{
Users can specify survival probabilities, accrual and follow-up durations, allocation ratios,
non-inferiority margins, transformation methods, and test types. The app dynamically adjusts input UI
based on the selected design and displays results in a data table format.

\strong{Test Types:}
\itemize{
\item \code{"ni"} - Non-Inferiority (two-group exponential survival comparison)
\item \code{"sup"} - Superiority (Lakatos method with logrank/Gehan/Tarone-Ware weighting)
\item \code{"one"} - One-sample survival test with multiple transformation options
}

\strong{Included References:}
\itemize{
\item Jung SH, Chow SC. Journal of Biopharmaceutical Statistics, 2012.
\item Lakatos E. Biometrics, 1988.
\item Lakatos & Lan. Statistics in Medicine, 1992.
\item Fleming & Harrington. Counting Processes and Survival Analysis, 1991.
\item Borgan 0, Andersen PK et al. Springer-Verlag, 1993.
\item Nagashima et al. Pharmaceutical Statistics, 2020.
}
}
\note{
Requires associated functions \code{twoSurvSampleSizeNI()}, \code{lakatosSampleSize()}, and \code{oneSurvSampleSize()}
to be defined in the environment. Assumes a CSS file is available at \code{"www/style.css"} for custom styling.
}
\examples{
if (interactive()) {
  rashnuBasic()
}

}
