% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kbl-defaults.R
\name{fmt_kbl}
\alias{fmt_kbl}
\title{Wrapper function of kableExtra::kbl}
\usage{
fmt_kbl(
  x,
  booktabs = TRUE,
  linesep = "",
  centering = FALSE,
  escape = FALSE,
  position = "left",
  latex_options = "HOLD_position",
  ...
)
}
\arguments{
\item{x}{For \code{kable()}, \code{x} is an R object, which is typically a
matrix or data frame. For \code{kables()}, a list with each element being a
returned value from \code{kable()}.}

\item{booktabs}{T/F for whether to enable the booktabs format for tables. I
personally would recommend you turn this on for every latex table except
some special cases.}

\item{linesep}{By default, in booktabs tables, \code{kable} insert an extra space
every five rows for clear display. If you don't want this feature or if you
want to do it in a different pattern, you can consider change this option.
The default is c('', '', '', '', '\\addlinespace'). Also, if you are not
using booktabs, but you want a cleaner display, you can change this to ''.}

\item{centering}{T (default)/F. Whether to center tables in the table
environment.}

\item{escape}{Boolean; whether to escape special characters when producing
HTML or LaTeX tables. When \code{escape = FALSE}, you have to make sure
that special characters will not trigger syntax errors in LaTeX or HTML.}

\item{position}{This is the "real" or say floating position for the latex
table environment. The \code{kable} only puts tables in a table environment when
a caption is provided. That is also the reason why your tables will be
floating around if you specify captions for your table. Possible choices are
\code{h} (here), \code{t} (top, default), \code{b} (bottom) and \code{p} (on a dedicated page).}

\item{latex_options}{A character vector for LaTeX table options. Please see
package vignette for more information. Possible options include
\code{basic}, \code{striped}, \code{hold_position}, \code{HOLD_position}, \code{scale_down}, \code{scale_up} & \code{repeat_header}.
\code{striped} will add alternative row colors to the table. It will imports
\code{LaTeX} package \code{xcolor} if enabled. \code{hold_position} will "hold" the floating
table to the exact position. It is useful when the \code{LaTeX} table is contained
in a \code{table} environment after you specified captions in \code{kable()}. It will
force the table to stay in the position where it was created in the document.
A stronger version: \code{HOLD_position} requires the \code{float} package and specifies \verb{[H]}.
\code{scale_down} is useful for super wide table. It will automatically adjust
the table to page width. \code{repeat_header} in only meaningful in a longtable
environment. It will let the header row repeat on every page in that long
table.}

\item{...}{Additional parameters passed to \code{\link[kableExtra:kbl]{kableExtra::kbl()}}.}
}
\value{
A kable object.
}
\description{
Create a kable table with some reasonable ATLAS defaults.
}
\examples{
fmt_kbl(mtcars[, 1:3], align = c("r", "c", "r"),
  col.names = c("Column 1", "Column 2", "Column 3"),
  caption = "Example Table Title")

}
