% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs-cat-functions.R
\name{abs_cat_tables}
\alias{abs_cat_tables}
\title{Return ABS catalogue tables}
\usage{
abs_cat_tables(cat_no, releases = "Latest", types = c("tss", "css"),
  include_urls = FALSE)
}
\arguments{
\item{cat_no}{ABS catalogue numbers.}

\item{releases}{Date or character string object specifying the month and year denoting which
release to download. Default is "Latest", which downloads the latest available data. See
examples for further details.}

\item{types}{ABS publication types to return. Permissable options include one or more of: 'tss'
-- ABS Time Series Spreadsheets, 'css' - ABS Data Cubes and 'pub' -- ABS Publications. The
default returns all Time Series Spreadsheets and Data Cubes.}

\item{include_urls}{Include full URLs to returned ABS data files. Default (FALSE) does not
include data file URLs.}
}
\value{
Returns a data frame listing the data collection tables and links.
}
\description{
Return list of tables from specified ABS catalogue number
}
\examples{
  \donttest{
    ## List latest available quarterly National Accounts tables
    ana_tables <- abs_cat_tables("5206.0", releases="Latest");
    ana_tables_url <- abs_cat_tables("5206.0", releases="Latest", include_urls=TRUE);
  
    ## List latest available CPI Time Series Spreadsheet tables only
    cpi_tables <- abs_cat_tables("6401.0", releases="Latest", types="tss");
    cpi_tables_url <- abs_cat_tables("5206.0", releases="Latest", types="tss", include_urls=TRUE);
  
    ## List latest available ASGS Volume 3 Data Cubes
    asgs_vol3_tables <- abs_cat_tables("1270.0.55.003", releases="Latest", types="css");
    asgs_vol3_tables_url <- abs_cat_tables("1270.0.55.003", releases="Latest",
                                           types="css", include_urls=TRUE);
  
    ## List latest available ASGS ANZSIC publications (PDF) files
    anzsic_2006 <- abs_cat_tables("1292.0", releases="Latest", types="pub", include_urls=TRUE);
  }
}
\author{
David Mitchell <david.pk.mitchell@gmail.com>
}
