% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rba-functions.R
\name{rba_search}
\alias{rba_search}
\title{Return list of data tables from RBA website}
\usage{
rba_search(
  pattern,
  fields = c("table_no", "table_name"),
  series_type = "statistical tables",
  ignore.case = TRUE,
  update_cache = FALSE
)
}
\arguments{
\item{pattern}{Character string or regular expression to be matched}

\item{fields}{Character vector of column names through which to search. By default, the function
searches 'table_no' and 'table_name'.}

\item{series_type}{Character vector specifying one or more one of 'statistical tables', 'historical data' or
'discontinued data'. By default, \code{series_type = 'statistical tables'}.}

\item{ignore.case}{Case senstive pattern match or not.}

\item{update_cache}{Logical expression, if FALSE (default), use the cached list of available
RBA tables (\code{rba_cachelist}), if TRUE, update the list of available datasets.}
}
\value{
data frame in long format
}
\description{
Function to return a list of all RBA data tables.
}
\examples{
 rba_datasets <- rba_search(pattern = "Liabilities and Assets");
}
\author{
David Mitchell <david.pk.mitchell@gmail.com>
}
