% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-tools.R
\name{pipeline_settings_get_set}
\alias{pipeline_settings_get_set}
\alias{pipeline_settings_set}
\alias{pipeline_settings_get}
\title{Get or change pipeline input parameter settings}
\usage{
pipeline_settings_set(
  ...,
  pipeline_path = Sys.getenv("RAVE_PIPELINE", "."),
  pipeline_settings_path = file.path(pipeline_path, "settings.yaml")
)

pipeline_settings_get(
  key,
  default = NULL,
  constraint = NULL,
  pipeline_path = Sys.getenv("RAVE_PIPELINE", "."),
  pipeline_settings_path = file.path(pipeline_path, "settings.yaml")
)
}
\arguments{
\item{pipeline_path}{the root directory of the pipeline}

\item{pipeline_settings_path}{the settings file of the pipeline, must be
a 'yaml' file; default is \code{'settings.yaml'} in the current pipeline}

\item{key, ...}{the character key(s) to get or set}

\item{default}{the default value is key is missing}

\item{constraint}{the constraint of the resulting value; if not \code{NULL},
then result must be within the \code{constraint} values, otherwise the
first element of \code{constraint} will be returned. This is useful to make
sure the results stay within given options}
}
\value{
\code{pipeline_settings_set} returns a list of all the settings.
\code{pipeline_settings_get} returns the value of given key.
}
\description{
Get or change pipeline input parameter settings
}
