% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threeBrain-instance.R
\name{rave_brain}
\alias{rave_brain}
\title{Load 'FreeSurfer' or 'AFNI/SUMA' brain from 'RAVE'}
\usage{
rave_brain(
  subject,
  surfaces = "pial",
  use_141 = TRUE,
  recache = FALSE,
  clean_before_cache = FALSE,
  compute_template = FALSE,
  usetemplateifmissing = FALSE,
  include_electrodes = TRUE
)
}
\arguments{
\item{subject}{character, list, or \code{\link{RAVESubject}} instance; for
list or other objects, make sure \code{subject$subject_id} is a valid 'RAVE'
subject 'ID'}

\item{surfaces}{one or more brain surface types from \code{"pial"},
\code{"white"}, \code{"smoothwm"}, \code{"pial-outer-smoothed"}, etc.;
check \code{\link[threeBrain]{freesurfer_brain2}}}

\item{use_141}{whether to use 'AFNI/SUMA' standard 141 brain}

\item{recache}{whether to re-calculate cache; only should be used when
the original 'FreeSurfer' or 'AFNI/SUMA' files are changed; such as new
files are added}

\item{clean_before_cache}{whether to clean the original cache before
\code{recache}; only set it to be true if original cached files are
corrupted}

\item{compute_template}{whether to compute template mappings; useful when
template mapping with multiple subjects are needed}

\item{usetemplateifmissing}{whether to use template brain when the subject
brain files are missing. If set to true, then a template (usually 'N27')
brain will be displayed as an alternative solution, and electrodes will be
rendered according to their \code{'MNI305'} coordinates, or
\code{'VertexNumber'} if given.}

\item{include_electrodes}{whether to include electrode in the model; default
is true}
}
\value{
A \code{'threeBrain'} instance if brain is found or
\code{usetemplateifmissing} is set to true; otherwise returns \code{NULL}
}
\description{
Create 3D visualization of the brain and visualize with
modern web browsers
}
\examples{


# Please make sure DemoSubject is correctly installed
# The subject is ~1GB from Github
brain <- rave_brain("demo/DemoSubject")

brain

if(interactive() && !is.null(brain)){
  brain$plot()
}


}
