% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subdivide_mesh.R
\name{subdivide_mesh}
\alias{subdivide_mesh}
\title{Subdivide Mesh}
\usage{
subdivide_mesh(
  scene,
  id = NA,
  subdivision_levels = 2,
  simple = FALSE,
  normals = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{scene}{The scene to subdivide.}

\item{id}{Default \code{NA}, all shapes. The index of which shape to subdivide.}

\item{subdivision_levels}{Default \code{1}.
Number of Loop subdivisions to be applied to the mesh.}

\item{simple}{Default \code{FALSE}. Whether to use simple subdivision, which does
not change the appearance of the mesh but does create a finer mesh.}

\item{normals}{Default \code{TRUE}. Whether to calculate subdivided vertex normals.}

\item{verbose}{Default \code{FALSE}.}
}
\value{
Scene with shape added.
}
\description{
Applies Loop subdivision to the scene (or selected meshes).
}
\examples{
if(run_documentation()) {
#Subdivide the included R mesh
obj_mesh(r_obj(),position=c(-0.5,0,0)) |> 
  add_shape(subdivide_mesh(obj_mesh(r_obj(),position=c(0.5,0,0)),
                           subdivision_levels = 2)) |> 
  rasterize_scene(light_info = directional_light(direction=c(0.2,0.5,1)),fov=13)
}
}
