% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.R
\name{generate_line}
\alias{generate_line}
\title{Generate Lines}
\usage{
generate_line(start = c(0, 0, 0), end = c(0, 1, 0), color = "white")
}
\arguments{
\item{start}{Default `c(0,0,0)`. Start of the line segment.}

\item{end}{Default `c(0,1,0)`. End of the line segment..}

\item{color}{Default `white`. Color of the line segment.}
}
\value{
Line matrix
}
\description{
Generate Lines
}
\examples{
if(rayvertex:::run_documentation()) {
# Make a spiral of lines
t = seq(0,8*pi,length.out=361)
line_mat = matrix(nrow=0,ncol=9)

for(i in 1:360) {
  line_mat = add_lines(line_mat,
                      generate_line(start = c(0.5*sin(t[i]), t[i]/(8*pi), 0.5*cos(t[i])),
                                    end  = c(0.5*sin(t[i+1]), t[i+1]/(8*pi), 0.5*cos(t[i+1]))))
}
rasterize_lines(line_mat)
}
if(rayvertex:::run_documentation()) {
#Change the line color
line_mat = matrix(nrow=0,ncol=9)
cols = hsv(seq(0,1,length.out=360))
for(i in 1:360) {
  line_mat = add_lines(line_mat,
                      generate_line(start = c(sin(t[i]), 2*t[i]/(8*pi), cos(t[i])),
                                   end  = c(sin(t[i+1]), 2*t[i+1]/(8*pi), cos(t[i+1])),
                                   color = cols[i]))
}
rasterize_lines(line_mat,lookfrom=c(0,10,10),fov=15)
}
if(rayvertex:::run_documentation()) {
#Use in a scene with a mesh
obj_mesh(r_obj(),material=material_list(diffuse="dodgerblue")) |>
 rasterize_scene(line_info = line_mat, light_info = directional_light(c(0,1,1)),
                 lookfrom=c(0,5,10),lookat=c(0,0.8,0),fov=15)
}
}
