% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-indexes.R
\name{indexreport_get}
\alias{indexreport_get}
\alias{indexreport_mget}
\title{Fetches indexes data from B3}
\usage{
indexreport_mget(
  first_date = Sys.Date() - 5,
  last_date = Sys.Date(),
  by = 1,
  cache_folder = cachedir(),
  do_cache = TRUE
)

indexreport_get(
  refdate = Sys.Date(),
  cache_folder = cachedir(),
  do_cache = TRUE
)
}
\arguments{
\item{first_date}{First date ("YYYY-MM-DD") to \code{yc_mget} multiple curves}

\item{last_date}{Last date ("YYYY-MM-DD") to \code{yc_mget} multiple curves}

\item{by}{Number of days in between fetched dates (default = 1) in \code{yc_mget}}

\item{cache_folder}{Location of cache folder (default = cachedir())}

\item{do_cache}{Whether to use cache or not (default = TRUE)}

\item{refdate}{Specific date ("YYYY-MM-DD") to \code{yc_get} single curve}
}
\value{
A dataframe with index data (OHLC, average and daily oscilation)
}
\description{
Downloads index data from B3 website
\url{https://www.b3.com.br/pt_br/market-data-e-indices/servicos-de-dados/market-data/historico/boletins-diarios/pesquisa-por-pregao/pesquisa-por-pregao/}.
}
\details{
\code{indexreport_get} returns index data for the given date and
\code{indexreport_mget} returns index data for a given range of dates.
}
\examples{
\dontrun{
df_ir <- indexreport_mget(Sys.Date() - 5, Sys.Date())
head(df_ir)
}
\dontrun{
df_ir <- indexreport_get(Sys.Date())
head(df_ir)
}
}
