% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrate.R
\name{accrate.age}
\alias{accrate.age}
\title{Obtain estimated accumulation rates for any age of a core.}
\usage{
accrate.age(
  age,
  set = get("info"),
  cmyr = FALSE,
  ages = c(),
  BCAD = set$BCAD,
  silent = TRUE,
  na.rm = FALSE
)
}
\arguments{
\item{age}{The age for which the accumulation rates need to be returned.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{cmyr}{Accumulation rates can be calculated in cm/year or year/cm. By default \code{cmyr=FALSE} and accumulation rates are calculated in year per cm.}

\item{ages}{The ages of the age-depth model. Not provided by default, but can be provided to speed things up if the function is called repeatedly}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{silent}{Warn when ages are outside the core's range. Default \code{silent=TRUE}.}

\item{na.rm}{Remove NA entries. These are NOT removed by default, ensuring that always the same amount of iterations is returned.}
}
\value{
all MCMC estimates of accumulation rate of the chosen age.
}
\description{
Obtain accumulation rates (in years per cm, so actually sedimentation times) as estimated by the MCMC iterations for any age of a core.
}
\details{
Considering accumulation rates is crucial for age-depth modelling, and even more so if they are subsequently
used for calculating proxy influx values, or interpreted as proxy for environmental change such as carbon accumulation. See also \code{accrate.age.ghost}, \code{accrate.depth} and \code{accrate.depth.ghost}.
Bacon deals explicitly with accumulation rate and its variability through defining prior distributions.
This function obtains accumulation rates (in years per cm, so actually sedimentation times) as estimated
by the MCMC iterations for any age of a core. Deals with only 1 age at a time. See also \code{accrate.depth}.
}
\examples{
\dontrun{
  Bacon(run=FALSE, coredir=tempfile())
  agedepth(yr.res=50, d.res=50, d.by=10)
  accrate.a5000 <- accrate.age(5000)
  plot(accrate.a5000, pch='.')
  hist(accrate.a5000)
}
}
\author{
Maarten Blaauw, J. Andres Christen
}
