% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrate.R
\name{accrate.depth.summary}
\alias{accrate.depth.summary}
\title{Provide a summary of the estimated accumulation rates for any depth of a core.}
\usage{
accrate.depth.summary(
  d,
  set = get("info"),
  cmyr = FALSE,
  na.rm = FALSE,
  probs = c(0.025, 0.16, 0.84, 0.975, 0.5)
)
}
\arguments{
\item{d}{The depth for which accumulation rates need to be returned.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{cmyr}{Accumulation rates can be calculated in cm/year or year/cm. By default \code{cmyr=FALSE} and accumulation rates are calculated in year per cm.}

\item{na.rm}{Remove NA entries. These are NOT removed by default, so that always the same amount of iterations is returned.}

\item{probs}{The probability ranges to be returned. Defaults to the minima and maxima of the 95\% and 68\% ranges, as well as the median: \code{probs=c(.025, .16, .84, .975, .5)}.}
}
\value{
A summary of the estimated accumulation rate of the chosen depth: minimum of the 95\% interval, minimum of the 68\% interval, maximum of the 68\% interval, maximum of the 95\% interval, median (i.e., 50\%) and mean.
}
\description{
Obtain a summary (95\% range, 68\% range, median, mean) of the accumulation rates (in years per cm, so actually sedimentation times) as estimated by the MCMC iterations for any depth of a core.
}
\examples{
\dontrun{
  Bacon(run=FALSE, coredir=tempfile())
  agedepth(yr.res=50, d.res=50, d.by=10)
  accrate.depth.summary(20)
}
}
\author{
Maarten Blaauw
}
