% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbt.R
\name{nbt_byte}
\alias{nbt_byte}
\alias{nbt_short}
\alias{nbt_int}
\alias{nbt_long}
\alias{nbt_float}
\alias{nbt_double}
\alias{nbt_byte_array}
\alias{nbt_string}
\alias{nbt_raw_string}
\alias{nbt_int_array}
\alias{nbt_long_array}
\alias{nbt_compound}
\alias{nbt_list}
\alias{is_nbt}
\alias{payload}
\alias{unnbt}
\alias{get_nbt_tag}
\title{Create an NBT value}
\usage{
nbt_byte(x)

nbt_short(x)

nbt_int(x)

nbt_long(x)

nbt_float(x)

nbt_double(x)

nbt_byte_array(x)

nbt_string(x)

nbt_raw_string(x)

nbt_int_array(x)

nbt_long_array(x)

nbt_compound(...)

nbt_list(...)

is_nbt(x)

payload(x)

unnbt(x)

get_nbt_tag(x)
}
\arguments{
\item{x}{An nbt value}

\item{...}{Arguments to collect into an NBT compound or NBT list value.
Supports dynamic dots via \code{rlang::list2()}.}
}
\description{
The Named Binary Tag (NBT) format is used by Minecraft for various data
types. An NBT value holds a 'payload' of data and a 'tag' indicating the type
of data held.

\verb{nbt_*()} family of functions create nbt data types.
\code{unnbt()} recursively strips NBT metadata from an NBT value.

\code{payload()} reads an nbt value's payload.

\code{get_nbt_tag()} returns the NBT tag corresponding to and NBT value.
}
