% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.R
\name{Blocks}
\alias{Blocks}
\alias{get_blocks_value}
\alias{get_blocks_data}
\alias{put_blocks_value}
\alias{put_blocks_data}
\title{Read and write Blocks data}
\usage{
get_blocks_value(
  x,
  z,
  dimension,
  db = default_db(),
  names_only = FALSE,
  extra_block = !names_only
)

get_blocks_data(
  x,
  z,
  dimension,
  db = default_db(),
  names_only = FALSE,
  extra_block = !names_only
)

put_blocks_value(value, x, z, dimension, db = default_db())

put_blocks_data(values, x, z, dimension, db = default_db())
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{names_only}{A logical scalar. Return only the names of the blocks,
ignoring block states.}

\item{extra_block}{A logical scalar. Append the extra block layer to the
output (separated by ";"). This is mostly useful if you have waterlogged
blocks. If the extra block is air, it will not be appended.}

\item{value}{A 16x384x16 character array.}

\item{values}{A (named) list of Blocks values. If \code{x} is missing, the names
of \code{values} will be taken as the keys.}
}
\value{
\code{get_blocks_value()} returns a Blocks value. \code{get_blocks_data()}
returns a named list of Blocks values.
}
\description{
Blocks data stores information about blocks in a world and their properties.
Blocks data is stored per-subchunk as \link{SubChunkBlocks} data. These functions
are wrappers around a SubChunkBlocks functions to make it easy to save and
load blocks for an entire chunk.
}
\details{
\itemize{
\item \code{get_blocks_value()} and \code{get_blocks_data()} load Blocks
data from \code{db}. \code{get_blocks_value()} loads data for a single chunk,
and \code{get_blocks_data()} loads data for multiple chunks.
\item \code{put_blocks_value()} and \code{put_blocks_data()} store Blocks
data into \code{db}.
}
}
\seealso{
SubChunkBlocks
}
