% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_model.R
\name{insert_lines}
\alias{insert_lines}
\alias{insert_lines.bi_model}
\title{Insert lines in a LibBi model}
\usage{
\method{insert_lines}{bi_model}(x, lines, before, after, at_beginning_of, at_end_of, ...)
}
\arguments{
\item{x}{a \code{\link{bi_model}} object}

\item{lines}{vector or line(s)}

\item{before}{line number before which to insert line(s)}

\item{after}{line number after which to insert line(s)}

\item{at_beginning_of}{block at the beginning of which to insert lines(s)}

\item{at_end_of}{block at the end of which to insert lines(s)}

\item{...}{ignored}
}
\value{
the updated \code{bi_model} object
}
\description{
Inserts one or more lines into a libbi model. If one of \code{before} or \code{after} is given, the line(s) will be inserted before or after a given line number or block name, respectively. If one of \code{at_beginning of} or \code{at_end_of} is given, the lines will be inserted at the beginning/end of the block, respectively.
}
\examples{
model_file_name <- system.file(package="rbi", "PZ.bi")
PZ <- bi_model(filename = model_file_name)
PZ <- insert_lines(PZ, lines = "noise beta", after = 8)
}
\seealso{
\code{\link{bi_model}}
}
