% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_collections}
\alias{rba_jaspar_collections}
\title{List collections available in JASPAR}
\usage{
rba_jaspar_collections(release = 2020, ...)
}
\arguments{
\item{release}{Numeric: (default = 2020) Which JASPAR database release
to use? Available options are: 2014, 2016, 2018, and 2020.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame with collections' names and URLs.
}
\description{
JASPAR organizes matrix profiles into collections.
  Using this function, you can retrieve a list of available collections
  in a JASPAR release.
}
\section{Corresponding API Resources}{

 "GET "http://jaspar.genereg.net/api/v1/collections/"
}

\examples{
\donttest{
rba_jaspar_collections(release = 2020)
}

}
\references{
\itemize{
  \item Fornes O, Castro-Mondragon JA, Khan A, et al. JASPAR 2020: update
    of the open-access database of transcription factor binding profiles.
    Nucleic Acids Res. 2019; doi: 10.1093/nar/gkz1001
  \item Khan, A. and Mathelier, A. JASPAR RESTful API: accessing JASPAR
    data from any programming language. Bioinformatics, 2017, doi:
    10.1093/bioinformatics/btx804
  \item Khan, A. et al. JASPAR 2018: update of the open-access database
    of transcription factor binding profiles and its web framework.
    Nucleic Acids Res. 2018; 46:D260–D266, doi: 10.1093/nar/gkx1126
  \item
  \href{http://jaspar.genereg.net/api/v1/docs/}{JASPAR API Documentation}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_matrix_search}()},
\code{\link{rba_jaspar_matrix_versions}()},
\code{\link{rba_jaspar_matrix}()},
\code{\link{rba_jaspar_releases}()},
\code{\link{rba_jaspar_sites}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_taxons_matrices}()},
\code{\link{rba_jaspar_taxons}()},
\code{\link{rba_jaspar_tffm_search}()},
\code{\link{rba_jaspar_tffm}()}
}
\concept{"JASPAR"}
