% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_releases}
\alias{rba_jaspar_releases}
\title{Get information about JASPAR database releases}
\usage{
rba_jaspar_releases(release_number = NULL, ...)
}
\arguments{
\item{release_number}{Numeric: Which JASPAR database release number
information's to retrieve? If left NULL (the default), a list of all
JASPAR database releases will be returned. Available options are 1 to 8.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list that contains all JASPAR database releases' information or
  details of a particular release.
}
\description{
If a release number was supplied, this function will return the details
  of that release. Otherwise, if the function was called without "release"
  argument, a list of all JASPAR database releases will be returned.
}
\section{Corresponding API Resources}{

"GET "http://jaspar.genereg.net/api/v1/releases/"
 "GET "http://jaspar.genereg.net/api/v1/releases/{release_number}/"
}

\examples{
\donttest{
rba_jaspar_releases()
rba_jaspar_releases(7)
}

}
\references{
\itemize{
  \item Fornes O, Castro-Mondragon JA, Khan A, et al. JASPAR 2020: update
    of the open-access database of transcription factor binding profiles.
    Nucleic Acids Res. 2019; doi: 10.1093/nar/gkz1001
  \item Khan, A. and Mathelier, A. JASPAR RESTful API: accessing JASPAR
    data from any programming language. Bioinformatics, 2017, doi:
    10.1093/bioinformatics/btx804
  \item Khan, A. et al. JASPAR 2018: update of the open-access database
    of transcription factor binding profiles and its web framework.
    Nucleic Acids Res. 2018; 46:D260–D266, doi: 10.1093/nar/gkx1126
  \item
  \href{http://jaspar.genereg.net/api/v1/docs/}{JASPAR API Documentation}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_collections}()},
\code{\link{rba_jaspar_matrix_search}()},
\code{\link{rba_jaspar_matrix_versions}()},
\code{\link{rba_jaspar_matrix}()},
\code{\link{rba_jaspar_sites}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_taxons_matrices}()},
\code{\link{rba_jaspar_taxons}()},
\code{\link{rba_jaspar_tffm_search}()},
\code{\link{rba_jaspar_tffm}()}
}
\concept{"JASPAR"}
