% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{rba_options}
\alias{rba_options}
\title{Set rbioapi Global Options}
\usage{
rba_options(
  diagnostics = NULL,
  dir_name = NULL,
  retry_max = NULL,
  retry_wait = NULL,
  progress = NULL,
  save_file = NULL,
  skip_error = NULL,
  timeout = NULL,
  verbose = NULL
)
}
\arguments{
\item{diagnostics}{(Logical) (default = FALSE) Show diagnostics and
detailed messages with internal information.}

\item{dir_name}{(character) (default = "rbioapi") If the package needs to
generate a file path to save the server's response, a directory with this
name will be created in your working directory to save your files.}

\item{retry_max}{(Numeric) (default = 0) How many times should rbioapi
retry in case of 5xx server responses, errors related to the server
or no internet connectivity?}

\item{retry_wait}{(Numeric) (default = 10) Time in seconds to wait before
next retry in case of internet connection or server problems.}

\item{progress}{(Logical) (default = FALSE) Should a progress bar be
displayed?}

\item{save_file}{(Logical or character) (default = FALSE) Either:\itemize{
\item TRUE: In this case, the raw server's response file will be
automatically saved to a proper file path. use "dir_name" argument to
change the file's parent directory.
\item FALSE: (default) Do not automatically save server's response file.
\item Character: (Only when changing the option via "..." in
a functions call) A valid file path to save the server's response
file to the function that you are calling.}}

\item{skip_error}{(Logical) (default = FALSE if R is in the interactive mode,
TRUE otherwise) If TRUE, the code execution  will not be stopped in case
of errors (anything but HTTP status 200 from the server); Instead the
error message will be returned as the function's output. However, if FALSE,
in case of any error, the code execution will be halted and an error
message will be issued.}

\item{timeout}{(Numeric) (default = 90) The maximum time in seconds that
you are willing to wait for a server response before giving up and
stopping the function execution.}

\item{verbose}{(Logical) (Default = TRUE) Generate short informative
messages.}
}
\value{
If called without any argument, a Data frame with available options
  and their information; If Called with an argument, will Return
  NULL but Alters that option globally.
}
\description{
A safe way to change rbioapi's global options and behavior. see "arguments"
  section for available options.
  \cr Note that you are not limited to changing the options globally, you can
  include the option names and values in the '...' argument of any rbioapi
  function to alter the option(s) only in that function call;
  e.g. example_function(x, diagnostics = TRUE, timeout = 300).
  \cr Alternatively, you can call this function with no arguments, i.e.
  rba_options(), to retrieve a data frame of available rbioapi options and
  their current values.
}
\details{
Because this function validates your supplied changes, please
  \strong{\emph{only change rbioapi options using this function}} and avoid
  directly editing them.
}
\examples{
rba_options()
\dontrun{
rba_options(verbose = FALSE)
}
\dontrun{
rba_options(save_file = TRUE)
}
\dontrun{
rba_options(diagnostics = TRUE, progress = TRUE)
}

}
\seealso{
Other "Helper functions": 
\code{\link{rba_connection_test}()},
\code{\link{rba_pages}()}
}
\concept{"Helper functions"}
\keyword{Helper}
