% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_analysis.R
\name{rba_reactome_analysis_token}
\alias{rba_reactome_analysis_token}
\title{Return the Results Associated with a Token}
\usage{
rba_reactome_analysis_token(
  token,
  species,
  sort_by = "ENTITIES_PVALUE",
  order = "ASC",
  resource = "TOTAL",
  p_value = NULL,
  include_disease = TRUE,
  min = NULL,
  max = NULL,
  ...
)
}
\arguments{
\item{token}{A token associated to your previous Reactome analysis.}

\item{species}{Numeric or Character: NCBI Taxonomy identifier (Human
is 9606), species name (e.g. "Homo sapiens") or Reactome DbId (e.g
Homo sapiens is 48887). See
 \code{\link{rba_reactome_species}} or
 \href{https://reactome.org/content/schema/objects/Species/}{Reactome
 Data Schema: Entries: Species}.}

\item{sort_by}{Sort the result based on what column? available choices
are: "NAME", "TOTAL_ENTITIES", "TOTAL_INTERACTORS", "TOTAL_REACTIONS",
"FOUND_ENTITIES", "FOUND_INTERACTORS", "FOUND_REACTIONS", "ENTITIES_RATIO",
"ENTITIES_PVALUE", "ENTITIES_FDR" or "REACTIONS_RATIO"}

\item{order}{Sort Order. Can be either "ASC" (default) or "DESC".}

\item{resource}{Filter results based on the resource. Default is "TOTAL",
available choices are: "TOTAL", "UNIPROT", "ENSEMBL", "CHEBI", "IUPHAR",
"MIRBASE", "NCBI_PROTEIN", "EMBL", "COMPOUND", "ENTITIES_FDR" or
"PUBCHEM_COMPOUND".}

\item{p_value}{Set a P value threshold. Only results with P value equal to
or less than your supplied threshold will be returned. (default = 1,
Meaning no P value filtering)}

\item{include_disease}{Logical (default = TRUE) Should the disease pathways
be included in the results?}

\item{min}{(numeric) Minimum number of entities that a pathways should have
to be included in the results.}

\item{max}{(numeric) Maximum number of entities that a pathways should have
to be included in the results.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List containing the results and information of your analysis.
}
\description{
Use a token generated After a Reactome analysis
  (via \code{\link{rba_reactome_analysis}}) to Retrieve the analysis results.
  The output format is identical to the returned object of
  \code{\link{rba_reactome_analysis}}.
}
\details{
After Any Analysis, Reactome will associate a token to your analysis. It
  can be later used to in function that requires the token (e.g to retrieve
  the analysis results, download pdf).
  \cr Note that Reactome will store your token for only 7 days. You can
  download your full results with
  \code{\link{rba_reactome_analysis_download}}, and re-import it anytime to
  reactome (using \code{\link{rba_reactome_analysis_import}}) to generate
  a new token.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/AnalysisService/token/\{token\}"
}

\examples{
\dontrun{
rba_reactome_analysis_token(token = "MjAyMDEwMTYwMTI3MTNfMjY1MjM",
    species = 9606)
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/AnalysisService/}{Reactome Analysis
  Services API Documentation}
  \item \href{https://reactome.org/cite}{Citations note on Reactome website}
  }
}
\seealso{
\code{\link{rba_reactome_analysis}}

Other "Reactome Analysis Service": 
\code{\link{rba_reactome_analysis}()},
\code{\link{rba_reactome_analysis_download}()},
\code{\link{rba_reactome_analysis_import}()},
\code{\link{rba_reactome_analysis_mapping}()},
\code{\link{rba_reactome_analysis_pdf}()},
\code{\link{rba_reactome_analysis_species}()}
}
\concept{"Reactome Analysis Service"}
