% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.xlsx.r
\name{write.xlsx}
\alias{write.xlsx}
\title{Write data and summary information to a Microsoft Excel-compatible workbook.}
\usage{
write.xlsx(biom, outfile, depth = NULL, seed = 0)
}
\arguments{
\item{biom}{The BIOM object to save to the file.}

\item{outfile}{Path to the output xlsx file.}

\item{depth}{Depth to rarefy to. See \code{rarefy} function for details.
Only use \code{depth} with \code{BIOM} files of type
'OTU table' and integer count values.}

\item{seed}{Random seed to use in rarefying. See \code{rarefy} function
for details.}
}
\value{
On success, returns \code{NULL} invisibly.
}
\description{
Write data and summary information to a Microsoft Excel-compatible workbook.
}
\section{Note}{

Any data frame attributes on \code{biom} will be included as separate 
worksheets. An attribute named 'Reads Per Step' is treated specially and 
merged with the usual 'Reads Per Sample' tab - if provided, its row names 
should match those in \code{biom} exactly.
}

