% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdiv_ord_plot.r
\name{bdiv_ord_plot}
\alias{bdiv_ord_plot}
\title{Ordinate samples and taxa on a 2D plane based on beta diversity distances.}
\usage{
bdiv_ord_plot(
  biom,
  bdiv = "Bray-Curtis",
  ord = "PCoA",
  weighted = TRUE,
  layers = "petm",
  stat.by = NULL,
  facet.by = NULL,
  colors = TRUE,
  shapes = TRUE,
  tree = NULL,
  test = "adonis2",
  seed = 0,
  permutations = 999,
  rank = -1,
  taxa = 4,
  p.top = Inf,
  p.adj = "fdr",
  unc = "singly",
  caption = TRUE,
  ...
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{bdiv}{Beta diversity distance algorithm(s) to use. Options are:
\code{"Bray-Curtis"}, \code{"Manhattan"}, \code{"Euclidean"},
\code{"Jaccard"}, and \code{"UniFrac"}. For \code{"UniFrac"}, a
phylogenetic tree must be present in \code{biom} or explicitly
provided via \verb{tree=}. Multiple/abbreviated values allowed.
Default: \code{"Bray-Curtis"}}

\item{ord}{Method for reducing dimensionality. Options are:
\describe{
\item{\code{"PCoA"} - }{ Principal coordinate analysis; \code{\link[ape:pcoa]{ape::pcoa()}}. }
\item{\code{"UMAP"} - }{ Uniform manifold approximation and projection; \code{\link[uwot:umap]{uwot::umap()}}. }
\item{\code{"NMDS"} - }{ Nonmetric multidimensional scaling; \code{\link[vegan:metaMDS]{vegan::metaMDS()}}. }
\item{\code{"tSNE"} - }{ t-distributed stochastic neighbor embedding; \code{\link[tsne:tsne]{tsne::tsne()}}. }
}
Multiple/abbreviated values allowed. Default: \code{"PCoA"}}

\item{weighted}{Take relative abundances into account. When
\code{weighted=FALSE}, only presence/absence is considered.
Multiple values allowed. Default: \code{TRUE}}

\item{layers}{One or more of
\code{c("point", "spider", "ellipse", "name", "mean", "taxon", "arrow")}.
The first four are sample-centric; the last three are taxa-centric.
Single letter abbreviations are also accepted. For instance,
\code{c("point", "ellipse")} is equivalent to \code{c("p", "e")} and \code{"pe"}.
Default: \code{"pe"}}

\item{stat.by}{The categorical or numeric metadata field over which
statistics should be calculated. Required.}

\item{facet.by}{Dataset field(s) to use for faceting. Must be categorical.
Default: \code{NULL}}

\item{colors}{How to color the groups. Options are:
\describe{
\item{\code{TRUE} - }{ Automatically select colorblind-friendly colors. }
\item{\code{FALSE} or \code{NULL} - }{ Don't use colors. }
\item{a palette name - }{ Auto-select colors from this set. E.g. \code{"okabe"} }
\item{character vector - }{ Custom colors to use. E.g. \code{c("red", "#00FF00")} }
\item{named character vector - }{ Explicit mapping. E.g. \code{c(Male = "blue", Female = "red")} }
}
See "Aesthetics" section below for additional information.
Default: \code{TRUE}}

\item{shapes}{Shapes for each group.
Options are similar to \code{colors}'s: \code{TRUE}, \code{FALSE}, \code{NULL}, shape
names (typically integers 0 - 17), or a named vector mapping
groups to specific shape names.
See "Aesthetics" section below for additional information.
Default: \code{TRUE}}

\item{tree}{A \code{phylo} object representing the phylogenetic
relationships of the taxa in \code{biom}. Only required when
computing UniFrac distances. Default: \code{biom$tree}}

\item{test}{Permutational test for accessing significance. Options are:
\describe{
\item{\code{"adonis2"} - }{ Permutational MANOVA; \code{\link[vegan:adonis]{vegan::adonis2()}}. }
\item{\code{"mrpp"} - }{ Multiple response permutation procedure; \code{\link[vegan:mrpp]{vegan::mrpp()}}. }
\item{\code{"none"} - }{ Don't run any statistics. }
}
Abbreviations are allowed. Default: \code{"adonis2"}}

\item{seed}{Random seed for permutations. Default: \code{0}}

\item{permutations}{Number of random permutations to use.
Default: \code{999}}

\item{rank}{What rank(s) of taxa to display. E.g. \code{"Phylum"},
\code{"Genus"}, \code{".otu"}, etc. An integer vector can also be
given, where \code{1} is the highest rank, \code{2} is the second
highest, \code{-1} is the lowest rank, \code{-2} is the second
lowest, and \code{0} is the OTU "rank". Run \code{biom$ranks} to
see all options for a given rbiom object. Default: \code{-1}.}

\item{taxa}{Which taxa to display. An integer value will show the top n
most abundant taxa. A value 0 <= n < 1 will show any taxa with that
mean abundance or greater (e.g. \code{0.1} implies >= 10\%). A
character vector of taxa names will show only those named taxa.
Default: \code{6}.}

\item{p.top}{Only display taxa with the most significant differences in
abundance. If \code{p.top} is >= 1, then the \code{p.top} most
significant taxa are displayed. If \code{p.top} is less than one, all
taxa with an adjusted p-value <= \code{p.top} are displayed.
Recommended to be used in combination with the \code{taxa} parameter
to set a lower bound on the mean abundance of considered taxa.
Default: \code{Inf}}

\item{p.adj}{Method to use for multiple comparisons adjustment of
p-values. Run \code{p.adjust.methods} for a list of available
options. Default: \code{"fdr"}}

\item{unc}{How to handle unclassified, uncultured, and similarly ambiguous
taxa names. Options are:
\describe{
\item{\code{"singly"} - }{ Replaces them with the OTU name. }
\item{\code{"grouped"} - }{ Replaces them with a higher rank's name. }
\item{\code{"drop"} - }{ Excludes them from the result. }
\item{\code{"asis"} - }{ To not check/modify any taxa names. }
}
Abbreviations are allowed. Default: \code{"singly"}}

\item{caption}{Add methodology caption beneath the plot.
Default: \code{TRUE}}

\item{...}{Parameters for layer geoms (e.g. \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}).
Prefixing parameter names with a layer name ensures that a particular
parameter is passed to, and only to, that layer. For instance,
\code{point.size = 2} or \code{p.size = 2} ensures only the points
have their size set to \code{2}. Points can also be controlled with
the \code{pt.} prefix.}
}
\value{
A \code{ggplot2} plot.
The computed sample coordinates and ggplot command
are available as \code{$data} and \code{$code} respectively.
If \code{stat.by} is given, then \code{$stats} and
\code{$stats$code} are set.
If \code{rank} is given, then \code{$data$taxa_coords},
\code{$taxa_stats}, and \code{$taxa_stats$code} are set.
}
\description{
Ordinate samples and taxa on a 2D plane based on beta diversity distances.
}
\examples{
    library(rbiom)
    
    biom <- rarefy(hmp50)
    
    bdiv_ord_plot(biom, layers="pemt", stat.by="Body Site", rank="g")
    
}
\seealso{
Other beta_diversity: 
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_clusters}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{bdiv_ord_table}()},
\code{\link{bdiv_stats}()},
\code{\link{bdiv_table}()},
\code{\link{distmat_stats}()}

Other ordination: 
\code{\link{bdiv_ord_table}()},
\code{\link{distmat_ord_table}()}

Other visualization: 
\code{\link{adiv_boxplot}()},
\code{\link{adiv_corrplot}()},
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{plot_heatmap}()},
\code{\link{rare_corrplot}()},
\code{\link{rare_multiplot}()},
\code{\link{rare_stacked}()},
\code{\link{stats_boxplot}()},
\code{\link{stats_corrplot}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_heatmap}()},
\code{\link{taxa_stacked}()}
}
\concept{beta_diversity}
\concept{ordination}
\concept{visualization}
