% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bisonmap.R
\name{bisonmap}
\alias{bisonmap}
\alias{bisonmap.bison}
\alias{bisonmap.bison_solr}
\title{Make map to visualize BISON data.}
\usage{
bisonmap(
  input = NULL,
  tomap = "points",
  geom = geom_point,
  jitter = NULL,
  customize = NULL
)

\method{bisonmap}{bison}(
  input = NULL,
  tomap = "points",
  geom = geom_point,
  jitter = NULL,
  customize = NULL
)

\method{bisonmap}{bison_solr}(
  input = NULL,
  tomap = "points",
  geom = geom_point,
  jitter = NULL,
  customize = NULL
)
}
\arguments{
\item{input}{Input bison object.}

\item{tomap}{One of points (occurrences), county (counts by county), or state
(counts by state). For \code{bison} class objects, we stop with message if you
pass in data from \code{\link[=bison]{bison()}} that doesn't include data by each state. For
\code{bison_solr} class objects, we only allow \code{points}.}

\item{geom}{geom_point or geom_jitter, not quoted.}

\item{jitter}{jitter position, see ggplot2 help.}

\item{customize}{Pass in more to the plot.}
}
\value{
Map (using ggplot2 package) of points on a map.
}
\description{
Make map to visualize BISON data.
}
\examples{
\dontrun{
# Using function bison
library("ggplot2")
out <- bison(species="Accipiter", type="scientific_name", count=300)
bisonmap(input=out)
bisonmap(input=out, geom=geom_jitter, jitter=position_jitter(width = 0.3, 
  height = 0.3))

# Using function bison_solr
out <- bison_solr(scientificName='Ursus americanus', rows=200)
bisonmap(out)
}
}
